/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ConnectivityStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ConnectivityStatusContract
implements JsonSerializable<ConnectivityStatusContract> {
    private String name;
    private ConnectivityStatusType status;
    private String error;
    private OffsetDateTime lastUpdated;
    private OffsetDateTime lastStatusChange;
    private String resourceType;
    private boolean isOptional;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityStatusContract.class);

    public String name() {
        return this.name;
    }

    public ConnectivityStatusContract withName(String name) {
        this.name = name;
        return this;
    }

    public ConnectivityStatusType status() {
        return this.status;
    }

    public ConnectivityStatusContract withStatus(ConnectivityStatusType status) {
        this.status = status;
        return this;
    }

    public String error() {
        return this.error;
    }

    public ConnectivityStatusContract withError(String error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime lastUpdated() {
        return this.lastUpdated;
    }

    public ConnectivityStatusContract withLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public OffsetDateTime lastStatusChange() {
        return this.lastStatusChange;
    }

    public ConnectivityStatusContract withLastStatusChange(OffsetDateTime lastStatusChange) {
        this.lastStatusChange = lastStatusChange;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public ConnectivityStatusContract withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public ConnectivityStatusContract withIsOptional(boolean isOptional) {
        this.isOptional = isOptional;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectivityStatusContract"));
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model ConnectivityStatusContract"));
        }
        if (this.lastUpdated() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastUpdated in model ConnectivityStatusContract"));
        }
        if (this.lastStatusChange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property lastStatusChange in model ConnectivityStatusContract"));
        }
        if (this.resourceType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceType in model ConnectivityStatusContract"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("lastUpdated", this.lastUpdated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdated));
        jsonWriter.writeStringField("lastStatusChange", this.lastStatusChange == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastStatusChange));
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeBooleanField("isOptional", this.isOptional);
        jsonWriter.writeStringField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityStatusContract fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityStatusContract)jsonReader.readObject(reader -> {
            ConnectivityStatusContract deserializedConnectivityStatusContract = new ConnectivityStatusContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectivityStatusContract.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedConnectivityStatusContract.status = ConnectivityStatusType.fromString(reader.getString());
                    continue;
                }
                if ("lastUpdated".equals(fieldName)) {
                    deserializedConnectivityStatusContract.lastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStatusChange".equals(fieldName)) {
                    deserializedConnectivityStatusContract.lastStatusChange = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedConnectivityStatusContract.resourceType = reader.getString();
                    continue;
                }
                if ("isOptional".equals(fieldName)) {
                    deserializedConnectivityStatusContract.isOptional = reader.getBoolean();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedConnectivityStatusContract.error = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityStatusContract;
        });
    }
}

