/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.DataMaskingEntity;
import java.io.IOException;
import java.util.List;

public final class DataMasking
implements JsonSerializable<DataMasking> {
    private List<DataMaskingEntity> queryParams;
    private List<DataMaskingEntity> headers;

    public List<DataMaskingEntity> queryParams() {
        return this.queryParams;
    }

    public DataMasking withQueryParams(List<DataMaskingEntity> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public List<DataMaskingEntity> headers() {
        return this.headers;
    }

    public DataMasking withHeaders(List<DataMaskingEntity> headers) {
        this.headers = headers;
        return this;
    }

    public void validate() {
        if (this.queryParams() != null) {
            this.queryParams().forEach(e -> e.validate());
        }
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queryParams", this.queryParams, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DataMasking fromJson(JsonReader jsonReader) throws IOException {
        return (DataMasking)jsonReader.readObject(reader -> {
            DataMasking deserializedDataMasking = new DataMasking();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryParams".equals(fieldName)) {
                    List queryParams;
                    deserializedDataMasking.queryParams = queryParams = reader.readArray(reader1 -> DataMaskingEntity.fromJson(reader1));
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List headers;
                    deserializedDataMasking.headers = headers = reader.readArray(reader1 -> DataMaskingEntity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMasking;
        });
    }
}

