/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractInner;
import java.io.IOException;
import java.util.List;

public final class IssueCollection
implements JsonSerializable<IssueCollection> {
    private List<IssueContractInner> value;
    private Long count;
    private String nextLink;

    public List<IssueContractInner> value() {
        return this.value;
    }

    public Long count() {
        return this.count;
    }

    public IssueCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static IssueCollection fromJson(JsonReader jsonReader) throws IOException {
        return (IssueCollection)jsonReader.readObject(reader -> {
            IssueCollection deserializedIssueCollection = new IssueCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedIssueCollection.value = value = reader.readArray(reader1 -> IssueContractInner.fromJson(reader1));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedIssueCollection.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedIssueCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueCollection;
        });
    }
}

