/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.State;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class IssueContractBaseProperties
implements JsonSerializable<IssueContractBaseProperties> {
    private OffsetDateTime createdDate;
    private State state;
    private String apiId;

    public OffsetDateTime createdDate() {
        return this.createdDate;
    }

    public IssueContractBaseProperties withCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public State state() {
        return this.state;
    }

    public IssueContractBaseProperties withState(State state) {
        this.state = state;
        return this;
    }

    public String apiId() {
        return this.apiId;
    }

    public IssueContractBaseProperties withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDate", this.createdDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDate));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("apiId", this.apiId);
        return jsonWriter.writeEndObject();
    }

    public static IssueContractBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IssueContractBaseProperties)jsonReader.readObject(reader -> {
            IssueContractBaseProperties deserializedIssueContractBaseProperties = new IssueContractBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdDate".equals(fieldName)) {
                    deserializedIssueContractBaseProperties.createdDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIssueContractBaseProperties.state = State.fromString(reader.getString());
                    continue;
                }
                if ("apiId".equals(fieldName)) {
                    deserializedIssueContractBaseProperties.apiId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueContractBaseProperties;
        });
    }
}

