/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.NotificationContractInner;
import java.io.IOException;
import java.util.List;

public final class NotificationCollection
implements JsonSerializable<NotificationCollection> {
    private List<NotificationContractInner> value;
    private Long count;
    private String nextLink;

    public List<NotificationContractInner> value() {
        return this.value;
    }

    public NotificationCollection withValue(List<NotificationContractInner> value) {
        this.value = value;
        return this;
    }

    public Long count() {
        return this.count;
    }

    public NotificationCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public NotificationCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NotificationCollection fromJson(JsonReader jsonReader) throws IOException {
        return (NotificationCollection)jsonReader.readObject(reader -> {
            NotificationCollection deserializedNotificationCollection = new NotificationCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNotificationCollection.value = value = reader.readArray(reader1 -> NotificationContractInner.fromJson(reader1));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedNotificationCollection.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNotificationCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNotificationCollection;
        });
    }
}

