/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterExampleContract;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ParameterContract
implements JsonSerializable<ParameterContract> {
    private String name;
    private String description;
    private String type;
    private String defaultValue;
    private Boolean required;
    private List<String> values;
    private String schemaId;
    private String typeName;
    private Map<String, ParameterExampleContract> examples;
    private static final ClientLogger LOGGER = new ClientLogger(ParameterContract.class);

    public String name() {
        return this.name;
    }

    public ParameterContract withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ParameterContract withDescription(String description) {
        this.description = description;
        return this;
    }

    public String type() {
        return this.type;
    }

    public ParameterContract withType(String type) {
        this.type = type;
        return this;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public ParameterContract withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public ParameterContract withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public ParameterContract withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public String schemaId() {
        return this.schemaId;
    }

    public ParameterContract withSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public String typeName() {
        return this.typeName;
    }

    public ParameterContract withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public Map<String, ParameterExampleContract> examples() {
        return this.examples;
    }

    public ParameterContract withExamples(Map<String, ParameterExampleContract> examples) {
        this.examples = examples;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ParameterContract"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ParameterContract"));
        }
        if (this.examples() != null) {
            this.examples().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("schemaId", this.schemaId);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeMapField("examples", this.examples, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ParameterContract fromJson(JsonReader jsonReader) throws IOException {
        return (ParameterContract)jsonReader.readObject(reader -> {
            ParameterContract deserializedParameterContract = new ParameterContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedParameterContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedParameterContract.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedParameterContract.description = reader.getString();
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedParameterContract.defaultValue = reader.getString();
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedParameterContract.required = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedParameterContract.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("schemaId".equals(fieldName)) {
                    deserializedParameterContract.schemaId = reader.getString();
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedParameterContract.typeName = reader.getString();
                    continue;
                }
                if ("examples".equals(fieldName)) {
                    Map examples;
                    deserializedParameterContract.examples = examples = reader.readMap(reader1 -> ParameterExampleContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParameterContract;
        });
    }
}

