/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSettingsContractProperties;
import com.azure.resourcemanager.apimanagement.models.RegistrationDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.TermsOfServiceProperties;
import java.io.IOException;

public final class PortalSettingsContract
extends ProxyResource {
    private PortalSettingsContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private PortalSettingsContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    public PortalSettingsContract withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    public String validationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().validationKey();
    }

    public PortalSettingsContract withValidationKey(String validationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withValidationKey(validationKey);
        return this;
    }

    public SubscriptionsDelegationSettingsProperties subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    public PortalSettingsContract withSubscriptions(SubscriptionsDelegationSettingsProperties subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    public RegistrationDelegationSettingsProperties userRegistration() {
        return this.innerProperties() == null ? null : this.innerProperties().userRegistration();
    }

    public PortalSettingsContract withUserRegistration(RegistrationDelegationSettingsProperties userRegistration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withUserRegistration(userRegistration);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public PortalSettingsContract withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public TermsOfServiceProperties termsOfService() {
        return this.innerProperties() == null ? null : this.innerProperties().termsOfService();
    }

    public PortalSettingsContract withTermsOfService(TermsOfServiceProperties termsOfService) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withTermsOfService(termsOfService);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PortalSettingsContract fromJson(JsonReader jsonReader) throws IOException {
        return (PortalSettingsContract)((Object)jsonReader.readObject(reader -> {
            PortalSettingsContract deserializedPortalSettingsContract = new PortalSettingsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPortalSettingsContract.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPortalSettingsContract.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPortalSettingsContract.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPortalSettingsContract.innerProperties = PortalSettingsContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPortalSettingsContract;
        }));
    }
}

