/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import java.io.IOException;

public class ProductEntityBaseParameters
implements JsonSerializable<ProductEntityBaseParameters> {
    private String description;
    private String terms;
    private Boolean subscriptionRequired;
    private Boolean approvalRequired;
    private Integer subscriptionsLimit;
    private ProductState state;

    public String description() {
        return this.description;
    }

    public ProductEntityBaseParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    public String terms() {
        return this.terms;
    }

    public ProductEntityBaseParameters withTerms(String terms) {
        this.terms = terms;
        return this;
    }

    public Boolean subscriptionRequired() {
        return this.subscriptionRequired;
    }

    public ProductEntityBaseParameters withSubscriptionRequired(Boolean subscriptionRequired) {
        this.subscriptionRequired = subscriptionRequired;
        return this;
    }

    public Boolean approvalRequired() {
        return this.approvalRequired;
    }

    public ProductEntityBaseParameters withApprovalRequired(Boolean approvalRequired) {
        this.approvalRequired = approvalRequired;
        return this;
    }

    public Integer subscriptionsLimit() {
        return this.subscriptionsLimit;
    }

    public ProductEntityBaseParameters withSubscriptionsLimit(Integer subscriptionsLimit) {
        this.subscriptionsLimit = subscriptionsLimit;
        return this;
    }

    public ProductState state() {
        return this.state;
    }

    public ProductEntityBaseParameters withState(ProductState state) {
        this.state = state;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("terms", this.terms);
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired);
        jsonWriter.writeBooleanField("approvalRequired", this.approvalRequired);
        jsonWriter.writeNumberField("subscriptionsLimit", (Number)this.subscriptionsLimit);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static ProductEntityBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ProductEntityBaseParameters)jsonReader.readObject(reader -> {
            ProductEntityBaseParameters deserializedProductEntityBaseParameters = new ProductEntityBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.description = reader.getString();
                    continue;
                }
                if ("terms".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.terms = reader.getString();
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.subscriptionRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("approvalRequired".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.approvalRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("subscriptionsLimit".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.subscriptionsLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.state = ProductState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProductEntityBaseParameters;
        });
    }
}

