/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.ParameterExampleContract;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RepresentationContract
implements JsonSerializable<RepresentationContract> {
    private String contentType;
    private String schemaId;
    private String typeName;
    private List<ParameterContract> formParameters;
    private Map<String, ParameterExampleContract> examples;
    private static final ClientLogger LOGGER = new ClientLogger(RepresentationContract.class);

    public String contentType() {
        return this.contentType;
    }

    public RepresentationContract withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String schemaId() {
        return this.schemaId;
    }

    public RepresentationContract withSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public String typeName() {
        return this.typeName;
    }

    public RepresentationContract withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public List<ParameterContract> formParameters() {
        return this.formParameters;
    }

    public RepresentationContract withFormParameters(List<ParameterContract> formParameters) {
        this.formParameters = formParameters;
        return this;
    }

    public Map<String, ParameterExampleContract> examples() {
        return this.examples;
    }

    public RepresentationContract withExamples(Map<String, ParameterExampleContract> examples) {
        this.examples = examples;
        return this;
    }

    public void validate() {
        if (this.contentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contentType in model RepresentationContract"));
        }
        if (this.formParameters() != null) {
            this.formParameters().forEach(e -> e.validate());
        }
        if (this.examples() != null) {
            this.examples().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("schemaId", this.schemaId);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeArrayField("formParameters", this.formParameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("examples", this.examples, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RepresentationContract fromJson(JsonReader jsonReader) throws IOException {
        return (RepresentationContract)jsonReader.readObject(reader -> {
            RepresentationContract deserializedRepresentationContract = new RepresentationContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedRepresentationContract.contentType = reader.getString();
                    continue;
                }
                if ("schemaId".equals(fieldName)) {
                    deserializedRepresentationContract.schemaId = reader.getString();
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedRepresentationContract.typeName = reader.getString();
                    continue;
                }
                if ("formParameters".equals(fieldName)) {
                    List formParameters;
                    deserializedRepresentationContract.formParameters = formParameters = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    continue;
                }
                if ("examples".equals(fieldName)) {
                    Map examples;
                    deserializedRepresentationContract.examples = examples = reader.readMap(reader1 -> ParameterExampleContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRepresentationContract;
        });
    }
}

