/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SamplingType;
import java.io.IOException;

public final class SamplingSettings
implements JsonSerializable<SamplingSettings> {
    private SamplingType samplingType;
    private Double percentage;

    public SamplingType samplingType() {
        return this.samplingType;
    }

    public SamplingSettings withSamplingType(SamplingType samplingType) {
        this.samplingType = samplingType;
        return this;
    }

    public Double percentage() {
        return this.percentage;
    }

    public SamplingSettings withPercentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("samplingType", this.samplingType == null ? null : this.samplingType.toString());
        jsonWriter.writeNumberField("percentage", (Number)this.percentage);
        return jsonWriter.writeEndObject();
    }

    public static SamplingSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SamplingSettings)jsonReader.readObject(reader -> {
            SamplingSettings deserializedSamplingSettings = new SamplingSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("samplingType".equals(fieldName)) {
                    deserializedSamplingSettings.samplingType = SamplingType.fromString(reader.getString());
                    continue;
                }
                if ("percentage".equals(fieldName)) {
                    deserializedSamplingSettings.percentage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSamplingSettings;
        });
    }
}

