/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserTokenParameterProperties;
import com.azure.resourcemanager.apimanagement.models.KeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class UserTokenParameters
implements JsonSerializable<UserTokenParameters> {
    private UserTokenParameterProperties innerProperties;

    private UserTokenParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public KeyType keyType() {
        return this.innerProperties() == null ? null : this.innerProperties().keyType();
    }

    public UserTokenParameters withKeyType(KeyType keyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserTokenParameterProperties();
        }
        this.innerProperties().withKeyType(keyType);
        return this;
    }

    public OffsetDateTime expiry() {
        return this.innerProperties() == null ? null : this.innerProperties().expiry();
    }

    public UserTokenParameters withExpiry(OffsetDateTime expiry) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserTokenParameterProperties();
        }
        this.innerProperties().withExpiry(expiry);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static UserTokenParameters fromJson(JsonReader jsonReader) throws IOException {
        return (UserTokenParameters)jsonReader.readObject(reader -> {
            UserTokenParameters deserializedUserTokenParameters = new UserTokenParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedUserTokenParameters.innerProperties = UserTokenParameterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserTokenParameters;
        });
    }
}

