/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiEntityBaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;
import java.util.List;

public final class ApiContractUpdateProperties
extends ApiEntityBaseContract {
    private String displayName;
    private String serviceUrl;
    private String path;
    private List<Protocol> protocols;
    private Boolean isOnline;

    public String displayName() {
        return this.displayName;
    }

    public ApiContractUpdateProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public ApiContractUpdateProperties withServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApiContractUpdateProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public ApiContractUpdateProperties withProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    @Override
    public Boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public ApiContractUpdateProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        super.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        super.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiType(ApiType apiType) {
        super.withApiType(apiType);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiRevision(String apiRevision) {
        super.withApiRevision(apiRevision);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withIsCurrent(Boolean isCurrent) {
        super.withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiRevisionDescription(String apiRevisionDescription) {
        super.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiVersionDescription(String apiVersionDescription) {
        super.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withApiVersionSetId(String apiVersionSetId) {
        super.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withTermsOfServiceUrl(String termsOfServiceUrl) {
        super.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withContact(ApiContactInformation contact) {
        super.withContact(contact);
        return this;
    }

    @Override
    public ApiContractUpdateProperties withLicense(ApiLicenseInformation license) {
        super.withLicense(license);
        return this;
    }

    @Override
    public void validate() {
        if (this.authenticationSettings() != null) {
            this.authenticationSettings().validate();
        }
        if (this.subscriptionKeyParameterNames() != null) {
            this.subscriptionKeyParameterNames().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
        if (this.license() != null) {
            this.license().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("authenticationSettings", (JsonSerializable)this.authenticationSettings());
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", (JsonSerializable)this.subscriptionKeyParameterNames());
        jsonWriter.writeStringField("type", this.apiType() == null ? null : this.apiType().toString());
        jsonWriter.writeStringField("apiRevision", this.apiRevision());
        jsonWriter.writeStringField("apiVersion", this.apiVersion());
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent());
        jsonWriter.writeStringField("apiRevisionDescription", this.apiRevisionDescription());
        jsonWriter.writeStringField("apiVersionDescription", this.apiVersionDescription());
        jsonWriter.writeStringField("apiVersionSetId", this.apiVersionSetId());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeStringField("termsOfServiceUrl", this.termsOfServiceUrl());
        jsonWriter.writeJsonField("contact", (JsonSerializable)this.contact());
        jsonWriter.writeJsonField("license", (JsonSerializable)this.license());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("serviceUrl", this.serviceUrl);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ApiContractUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiContractUpdateProperties)jsonReader.readObject(reader -> {
            ApiContractUpdateProperties deserializedApiContractUpdateProperties = new ApiContractUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withDescription(reader.getString());
                    continue;
                }
                if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withAuthenticationSettings(AuthenticationSettingsContract.fromJson(reader));
                    continue;
                }
                if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiType(ApiType.fromString(reader.getString()));
                    continue;
                }
                if ("apiRevision".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiRevision(reader.getString());
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiVersion(reader.getString());
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withIsCurrent((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isOnline".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.isOnline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiRevisionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiVersionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withApiVersionSetId(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withTermsOfServiceUrl(reader.getString());
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withContact(ApiContactInformation.fromJson(reader));
                    continue;
                }
                if ("license".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.withLicense(ApiLicenseInformation.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.displayName = reader.getString();
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.serviceUrl = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedApiContractUpdateProperties.path = reader.getString();
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols;
                    deserializedApiContractUpdateProperties.protocols = protocols = reader.readArray(reader1 -> Protocol.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiContractUpdateProperties;
        });
    }
}

