/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractProperties;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.ContentFormat;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SoapApiType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import com.azure.resourcemanager.apimanagement.models.TranslateRequiredQueryParametersConduct;
import java.io.IOException;
import java.util.List;

public final class ApiCreateOrUpdateProperties
extends ApiContractProperties {
    private String value;
    private ContentFormat format;
    private ApiCreateOrUpdatePropertiesWsdlSelector wsdlSelector;
    private SoapApiType soapApiType;
    private TranslateRequiredQueryParametersConduct translateRequiredQueryParametersConduct;
    private String provisioningState;
    private Boolean isOnline;
    private static final ClientLogger LOGGER = new ClientLogger(ApiCreateOrUpdateProperties.class);

    public String value() {
        return this.value;
    }

    public ApiCreateOrUpdateProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public ContentFormat format() {
        return this.format;
    }

    public ApiCreateOrUpdateProperties withFormat(ContentFormat format) {
        this.format = format;
        return this;
    }

    public ApiCreateOrUpdatePropertiesWsdlSelector wsdlSelector() {
        return this.wsdlSelector;
    }

    public ApiCreateOrUpdateProperties withWsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelector wsdlSelector) {
        this.wsdlSelector = wsdlSelector;
        return this;
    }

    public SoapApiType soapApiType() {
        return this.soapApiType;
    }

    public ApiCreateOrUpdateProperties withSoapApiType(SoapApiType soapApiType) {
        this.soapApiType = soapApiType;
        return this;
    }

    public TranslateRequiredQueryParametersConduct translateRequiredQueryParametersConduct() {
        return this.translateRequiredQueryParametersConduct;
    }

    public ApiCreateOrUpdateProperties withTranslateRequiredQueryParametersConduct(TranslateRequiredQueryParametersConduct translateRequiredQueryParametersConduct) {
        this.translateRequiredQueryParametersConduct = translateRequiredQueryParametersConduct;
        return this;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public Boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public ApiCreateOrUpdateProperties withSourceApiId(String sourceApiId) {
        super.withSourceApiId(sourceApiId);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withServiceUrl(String serviceUrl) {
        super.withServiceUrl(serviceUrl);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withPath(String path) {
        super.withPath(path);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withProtocols(List<Protocol> protocols) {
        super.withProtocols(protocols);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        super.withApiVersionSet(apiVersionSet);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        super.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        super.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiType(ApiType apiType) {
        super.withApiType(apiType);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiRevision(String apiRevision) {
        super.withApiRevision(apiRevision);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withIsCurrent(Boolean isCurrent) {
        super.withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiRevisionDescription(String apiRevisionDescription) {
        super.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiVersionDescription(String apiVersionDescription) {
        super.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withApiVersionSetId(String apiVersionSetId) {
        super.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withTermsOfServiceUrl(String termsOfServiceUrl) {
        super.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withContact(ApiContactInformation contact) {
        super.withContact(contact);
        return this;
    }

    @Override
    public ApiCreateOrUpdateProperties withLicense(ApiLicenseInformation license) {
        super.withLicense(license);
        return this;
    }

    @Override
    public void validate() {
        if (this.wsdlSelector() != null) {
            this.wsdlSelector().validate();
        }
        if (this.authenticationSettings() != null) {
            this.authenticationSettings().validate();
        }
        if (this.subscriptionKeyParameterNames() != null) {
            this.subscriptionKeyParameterNames().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
        if (this.license() != null) {
            this.license().validate();
        }
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model ApiCreateOrUpdateProperties"));
        }
        if (this.apiVersionSet() != null) {
            this.apiVersionSet().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("authenticationSettings", (JsonSerializable)this.authenticationSettings());
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", (JsonSerializable)this.subscriptionKeyParameterNames());
        jsonWriter.writeStringField("type", this.apiType() == null ? null : this.apiType().toString());
        jsonWriter.writeStringField("apiRevision", this.apiRevision());
        jsonWriter.writeStringField("apiVersion", this.apiVersion());
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent());
        jsonWriter.writeStringField("apiRevisionDescription", this.apiRevisionDescription());
        jsonWriter.writeStringField("apiVersionDescription", this.apiVersionDescription());
        jsonWriter.writeStringField("apiVersionSetId", this.apiVersionSetId());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeStringField("termsOfServiceUrl", this.termsOfServiceUrl());
        jsonWriter.writeJsonField("contact", (JsonSerializable)this.contact());
        jsonWriter.writeJsonField("license", (JsonSerializable)this.license());
        jsonWriter.writeStringField("sourceApiId", this.sourceApiId());
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeStringField("serviceUrl", this.serviceUrl());
        jsonWriter.writeArrayField("protocols", this.protocols(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("apiVersionSet", (JsonSerializable)this.apiVersionSet());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        jsonWriter.writeJsonField("wsdlSelector", (JsonSerializable)this.wsdlSelector);
        jsonWriter.writeStringField("apiType", this.soapApiType == null ? null : this.soapApiType.toString());
        jsonWriter.writeStringField("translateRequiredQueryParameters", this.translateRequiredQueryParametersConduct == null ? null : this.translateRequiredQueryParametersConduct.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            ApiCreateOrUpdateProperties deserializedApiCreateOrUpdateProperties = new ApiCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withPath(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withDescription(reader.getString());
                    continue;
                }
                if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withAuthenticationSettings(AuthenticationSettingsContract.fromJson(reader));
                    continue;
                }
                if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiType(ApiType.fromString(reader.getString()));
                    continue;
                }
                if ("apiRevision".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiRevision(reader.getString());
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiVersion(reader.getString());
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withIsCurrent((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isOnline".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.isOnline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiRevisionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiVersionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiVersionSetId(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withTermsOfServiceUrl(reader.getString());
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withContact(ApiContactInformation.fromJson(reader));
                    continue;
                }
                if ("license".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withLicense(ApiLicenseInformation.fromJson(reader));
                    continue;
                }
                if ("sourceApiId".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withSourceApiId(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withDisplayName(reader.getString());
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withServiceUrl(reader.getString());
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols = reader.readArray(reader1 -> Protocol.fromString(reader1.getString()));
                    deserializedApiCreateOrUpdateProperties.withProtocols(protocols);
                    continue;
                }
                if ("apiVersionSet".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.withApiVersionSet(ApiVersionSetContractDetails.fromJson(reader));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.value = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.format = ContentFormat.fromString(reader.getString());
                    continue;
                }
                if ("wsdlSelector".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.wsdlSelector = ApiCreateOrUpdatePropertiesWsdlSelector.fromJson(reader);
                    continue;
                }
                if ("apiType".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.soapApiType = SoapApiType.fromString(reader.getString());
                    continue;
                }
                if ("translateRequiredQueryParameters".equals(fieldName)) {
                    deserializedApiCreateOrUpdateProperties.translateRequiredQueryParametersConduct = TranslateRequiredQueryParametersConduct.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiCreateOrUpdateProperties;
        });
    }
}

