/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ApiManagementGatewayResourceInner
extends ApimResource {
    private ApiManagementGatewayProperties innerProperties = new ApiManagementGatewayProperties();
    private ApiManagementGatewaySkuProperties sku;
    private SystemData systemData;
    private String location;
    private String etag;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementGatewayResourceInner.class);

    private ApiManagementGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiManagementGatewaySkuProperties sku() {
        return this.sku;
    }

    public ApiManagementGatewayResourceInner withSku(ApiManagementGatewaySkuProperties sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public ApiManagementGatewayResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApiManagementGatewayResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    public FrontendConfiguration frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    public ApiManagementGatewayResourceInner withFrontend(FrontendConfiguration frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    public BackendConfiguration backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    public ApiManagementGatewayResourceInner withBackend(BackendConfiguration backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    public GatewayConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    public ApiManagementGatewayResourceInner withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    public ApiManagementGatewayResourceInner withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ApiManagementGatewayResourceInner"));
        }
        this.innerProperties().validate();
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ApiManagementGatewayResourceInner"));
        }
        this.sku().validate();
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ApiManagementGatewayResourceInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayResourceInner)((Object)jsonReader.readObject(reader -> {
            ApiManagementGatewayResourceInner deserializedApiManagementGatewayResourceInner = new ApiManagementGatewayResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementGatewayResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.innerProperties = ApiManagementGatewayProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.sku = ApiManagementGatewaySkuProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.location = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayResourceInner;
        }));
    }
}

