/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendBaseParameters;
import com.azure.resourcemanager.apimanagement.models.BackendBaseParametersPool;
import com.azure.resourcemanager.apimanagement.models.BackendCircuitBreaker;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProtocol;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;
import com.azure.resourcemanager.apimanagement.models.BackendType;
import java.io.IOException;

public final class BackendUpdateParameterProperties
extends BackendBaseParameters {
    private String url;
    private BackendProtocol protocol;

    public String url() {
        return this.url;
    }

    public BackendUpdateParameterProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public BackendProtocol protocol() {
        return this.protocol;
    }

    public BackendUpdateParameterProperties withProtocol(BackendProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withTitle(String title) {
        super.withTitle(title);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withResourceId(String resourceId) {
        super.withResourceId(resourceId);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withProperties(BackendProperties properties) {
        super.withProperties(properties);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withCredentials(BackendCredentialsContract credentials) {
        super.withCredentials(credentials);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withProxy(BackendProxyContract proxy) {
        super.withProxy(proxy);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withTls(BackendTlsProperties tls) {
        super.withTls(tls);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withCircuitBreaker(BackendCircuitBreaker circuitBreaker) {
        super.withCircuitBreaker(circuitBreaker);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withPool(BackendBaseParametersPool pool) {
        super.withPool(pool);
        return this;
    }

    @Override
    public BackendUpdateParameterProperties withType(BackendType type) {
        super.withType(type);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
        if (this.proxy() != null) {
            this.proxy().validate();
        }
        if (this.tls() != null) {
            this.tls().validate();
        }
        if (this.circuitBreaker() != null) {
            this.circuitBreaker().validate();
        }
        if (this.pool() != null) {
            this.pool().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("resourceId", this.resourceId());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties());
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials());
        jsonWriter.writeJsonField("proxy", (JsonSerializable)this.proxy());
        jsonWriter.writeJsonField("tls", (JsonSerializable)this.tls());
        jsonWriter.writeJsonField("circuitBreaker", (JsonSerializable)this.circuitBreaker());
        jsonWriter.writeJsonField("pool", (JsonSerializable)this.pool());
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        return jsonWriter.writeEndObject();
    }

    public static BackendUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackendUpdateParameterProperties)jsonReader.readObject(reader -> {
            BackendUpdateParameterProperties deserializedBackendUpdateParameterProperties = new BackendUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("title".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withTitle(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withDescription(reader.getString());
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withResourceId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withProperties(BackendProperties.fromJson(reader));
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withCredentials(BackendCredentialsContract.fromJson(reader));
                    continue;
                }
                if ("proxy".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withProxy(BackendProxyContract.fromJson(reader));
                    continue;
                }
                if ("tls".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withTls(BackendTlsProperties.fromJson(reader));
                    continue;
                }
                if ("circuitBreaker".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withCircuitBreaker(BackendCircuitBreaker.fromJson(reader));
                    continue;
                }
                if ("pool".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withPool(BackendBaseParametersPool.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.withType(BackendType.fromString(reader.getString()));
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.url = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedBackendUpdateParameterProperties.protocol = BackendProtocol.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackendUpdateParameterProperties;
        });
    }
}

