/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DeletedServiceContractProperties
implements JsonSerializable<DeletedServiceContractProperties> {
    private String serviceId;
    private OffsetDateTime scheduledPurgeDate;
    private OffsetDateTime deletionDate;

    public String serviceId() {
        return this.serviceId;
    }

    public DeletedServiceContractProperties withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public DeletedServiceContractProperties withScheduledPurgeDate(OffsetDateTime scheduledPurgeDate) {
        this.scheduledPurgeDate = scheduledPurgeDate;
        return this;
    }

    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    public DeletedServiceContractProperties withDeletionDate(OffsetDateTime deletionDate) {
        this.deletionDate = deletionDate;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceId", this.serviceId);
        jsonWriter.writeStringField("scheduledPurgeDate", this.scheduledPurgeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledPurgeDate));
        jsonWriter.writeStringField("deletionDate", this.deletionDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletionDate));
        return jsonWriter.writeEndObject();
    }

    public static DeletedServiceContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedServiceContractProperties)jsonReader.readObject(reader -> {
            DeletedServiceContractProperties deserializedDeletedServiceContractProperties = new DeletedServiceContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceId".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.serviceId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.scheduledPurgeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deletionDate".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.deletionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedServiceContractProperties;
        });
    }
}

