/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AlwaysLog;
import com.azure.resourcemanager.apimanagement.models.HttpCorrelationProtocol;
import com.azure.resourcemanager.apimanagement.models.OperationNameFormat;
import com.azure.resourcemanager.apimanagement.models.PipelineDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.SamplingSettings;
import com.azure.resourcemanager.apimanagement.models.Verbosity;
import java.io.IOException;

public final class DiagnosticContractProperties
implements JsonSerializable<DiagnosticContractProperties> {
    private AlwaysLog alwaysLog;
    private String loggerId;
    private SamplingSettings sampling;
    private PipelineDiagnosticSettings frontend;
    private PipelineDiagnosticSettings backend;
    private Boolean logClientIp;
    private HttpCorrelationProtocol httpCorrelationProtocol;
    private Verbosity verbosity;
    private OperationNameFormat operationNameFormat;
    private Boolean metrics;
    private static final ClientLogger LOGGER = new ClientLogger(DiagnosticContractProperties.class);

    public AlwaysLog alwaysLog() {
        return this.alwaysLog;
    }

    public DiagnosticContractProperties withAlwaysLog(AlwaysLog alwaysLog) {
        this.alwaysLog = alwaysLog;
        return this;
    }

    public String loggerId() {
        return this.loggerId;
    }

    public DiagnosticContractProperties withLoggerId(String loggerId) {
        this.loggerId = loggerId;
        return this;
    }

    public SamplingSettings sampling() {
        return this.sampling;
    }

    public DiagnosticContractProperties withSampling(SamplingSettings sampling) {
        this.sampling = sampling;
        return this;
    }

    public PipelineDiagnosticSettings frontend() {
        return this.frontend;
    }

    public DiagnosticContractProperties withFrontend(PipelineDiagnosticSettings frontend) {
        this.frontend = frontend;
        return this;
    }

    public PipelineDiagnosticSettings backend() {
        return this.backend;
    }

    public DiagnosticContractProperties withBackend(PipelineDiagnosticSettings backend) {
        this.backend = backend;
        return this;
    }

    public Boolean logClientIp() {
        return this.logClientIp;
    }

    public DiagnosticContractProperties withLogClientIp(Boolean logClientIp) {
        this.logClientIp = logClientIp;
        return this;
    }

    public HttpCorrelationProtocol httpCorrelationProtocol() {
        return this.httpCorrelationProtocol;
    }

    public DiagnosticContractProperties withHttpCorrelationProtocol(HttpCorrelationProtocol httpCorrelationProtocol) {
        this.httpCorrelationProtocol = httpCorrelationProtocol;
        return this;
    }

    public Verbosity verbosity() {
        return this.verbosity;
    }

    public DiagnosticContractProperties withVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
        return this;
    }

    public OperationNameFormat operationNameFormat() {
        return this.operationNameFormat;
    }

    public DiagnosticContractProperties withOperationNameFormat(OperationNameFormat operationNameFormat) {
        this.operationNameFormat = operationNameFormat;
        return this;
    }

    public Boolean metrics() {
        return this.metrics;
    }

    public DiagnosticContractProperties withMetrics(Boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.loggerId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property loggerId in model DiagnosticContractProperties"));
        }
        if (this.sampling() != null) {
            this.sampling().validate();
        }
        if (this.frontend() != null) {
            this.frontend().validate();
        }
        if (this.backend() != null) {
            this.backend().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loggerId", this.loggerId);
        jsonWriter.writeStringField("alwaysLog", this.alwaysLog == null ? null : this.alwaysLog.toString());
        jsonWriter.writeJsonField("sampling", (JsonSerializable)this.sampling);
        jsonWriter.writeJsonField("frontend", (JsonSerializable)this.frontend);
        jsonWriter.writeJsonField("backend", (JsonSerializable)this.backend);
        jsonWriter.writeBooleanField("logClientIp", this.logClientIp);
        jsonWriter.writeStringField("httpCorrelationProtocol", this.httpCorrelationProtocol == null ? null : this.httpCorrelationProtocol.toString());
        jsonWriter.writeStringField("verbosity", this.verbosity == null ? null : this.verbosity.toString());
        jsonWriter.writeStringField("operationNameFormat", this.operationNameFormat == null ? null : this.operationNameFormat.toString());
        jsonWriter.writeBooleanField("metrics", this.metrics);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticContractProperties)jsonReader.readObject(reader -> {
            DiagnosticContractProperties deserializedDiagnosticContractProperties = new DiagnosticContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggerId".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.loggerId = reader.getString();
                    continue;
                }
                if ("alwaysLog".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.alwaysLog = AlwaysLog.fromString(reader.getString());
                    continue;
                }
                if ("sampling".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.sampling = SamplingSettings.fromJson(reader);
                    continue;
                }
                if ("frontend".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.frontend = PipelineDiagnosticSettings.fromJson(reader);
                    continue;
                }
                if ("backend".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.backend = PipelineDiagnosticSettings.fromJson(reader);
                    continue;
                }
                if ("logClientIp".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.logClientIp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("httpCorrelationProtocol".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.httpCorrelationProtocol = HttpCorrelationProtocol.fromString(reader.getString());
                    continue;
                }
                if ("verbosity".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.verbosity = Verbosity.fromString(reader.getString());
                    continue;
                }
                if ("operationNameFormat".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.operationNameFormat = OperationNameFormat.fromString(reader.getString());
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    deserializedDiagnosticContractProperties.metrics = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticContractProperties;
        });
    }
}

