/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AlwaysLog;
import com.azure.resourcemanager.apimanagement.models.HttpCorrelationProtocol;
import com.azure.resourcemanager.apimanagement.models.OperationNameFormat;
import com.azure.resourcemanager.apimanagement.models.PipelineDiagnosticSettings;
import com.azure.resourcemanager.apimanagement.models.SamplingSettings;
import com.azure.resourcemanager.apimanagement.models.Verbosity;
import java.io.IOException;

public final class DiagnosticContractUpdateProperties
implements JsonSerializable<DiagnosticContractUpdateProperties> {
    private AlwaysLog alwaysLog;
    private String loggerId;
    private SamplingSettings sampling;
    private PipelineDiagnosticSettings frontend;
    private PipelineDiagnosticSettings backend;
    private Boolean logClientIp;
    private HttpCorrelationProtocol httpCorrelationProtocol;
    private Verbosity verbosity;
    private OperationNameFormat operationNameFormat;
    private Boolean metrics;

    public AlwaysLog alwaysLog() {
        return this.alwaysLog;
    }

    public DiagnosticContractUpdateProperties withAlwaysLog(AlwaysLog alwaysLog) {
        this.alwaysLog = alwaysLog;
        return this;
    }

    public String loggerId() {
        return this.loggerId;
    }

    public DiagnosticContractUpdateProperties withLoggerId(String loggerId) {
        this.loggerId = loggerId;
        return this;
    }

    public SamplingSettings sampling() {
        return this.sampling;
    }

    public DiagnosticContractUpdateProperties withSampling(SamplingSettings sampling) {
        this.sampling = sampling;
        return this;
    }

    public PipelineDiagnosticSettings frontend() {
        return this.frontend;
    }

    public DiagnosticContractUpdateProperties withFrontend(PipelineDiagnosticSettings frontend) {
        this.frontend = frontend;
        return this;
    }

    public PipelineDiagnosticSettings backend() {
        return this.backend;
    }

    public DiagnosticContractUpdateProperties withBackend(PipelineDiagnosticSettings backend) {
        this.backend = backend;
        return this;
    }

    public Boolean logClientIp() {
        return this.logClientIp;
    }

    public DiagnosticContractUpdateProperties withLogClientIp(Boolean logClientIp) {
        this.logClientIp = logClientIp;
        return this;
    }

    public HttpCorrelationProtocol httpCorrelationProtocol() {
        return this.httpCorrelationProtocol;
    }

    public DiagnosticContractUpdateProperties withHttpCorrelationProtocol(HttpCorrelationProtocol httpCorrelationProtocol) {
        this.httpCorrelationProtocol = httpCorrelationProtocol;
        return this;
    }

    public Verbosity verbosity() {
        return this.verbosity;
    }

    public DiagnosticContractUpdateProperties withVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
        return this;
    }

    public OperationNameFormat operationNameFormat() {
        return this.operationNameFormat;
    }

    public DiagnosticContractUpdateProperties withOperationNameFormat(OperationNameFormat operationNameFormat) {
        this.operationNameFormat = operationNameFormat;
        return this;
    }

    public Boolean metrics() {
        return this.metrics;
    }

    public DiagnosticContractUpdateProperties withMetrics(Boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.sampling() != null) {
            this.sampling().validate();
        }
        if (this.frontend() != null) {
            this.frontend().validate();
        }
        if (this.backend() != null) {
            this.backend().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alwaysLog", this.alwaysLog == null ? null : this.alwaysLog.toString());
        jsonWriter.writeStringField("loggerId", this.loggerId);
        jsonWriter.writeJsonField("sampling", (JsonSerializable)this.sampling);
        jsonWriter.writeJsonField("frontend", (JsonSerializable)this.frontend);
        jsonWriter.writeJsonField("backend", (JsonSerializable)this.backend);
        jsonWriter.writeBooleanField("logClientIp", this.logClientIp);
        jsonWriter.writeStringField("httpCorrelationProtocol", this.httpCorrelationProtocol == null ? null : this.httpCorrelationProtocol.toString());
        jsonWriter.writeStringField("verbosity", this.verbosity == null ? null : this.verbosity.toString());
        jsonWriter.writeStringField("operationNameFormat", this.operationNameFormat == null ? null : this.operationNameFormat.toString());
        jsonWriter.writeBooleanField("metrics", this.metrics);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticContractUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticContractUpdateProperties)jsonReader.readObject(reader -> {
            DiagnosticContractUpdateProperties deserializedDiagnosticContractUpdateProperties = new DiagnosticContractUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alwaysLog".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.alwaysLog = AlwaysLog.fromString(reader.getString());
                    continue;
                }
                if ("loggerId".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.loggerId = reader.getString();
                    continue;
                }
                if ("sampling".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.sampling = SamplingSettings.fromJson(reader);
                    continue;
                }
                if ("frontend".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.frontend = PipelineDiagnosticSettings.fromJson(reader);
                    continue;
                }
                if ("backend".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.backend = PipelineDiagnosticSettings.fromJson(reader);
                    continue;
                }
                if ("logClientIp".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.logClientIp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("httpCorrelationProtocol".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.httpCorrelationProtocol = HttpCorrelationProtocol.fromString(reader.getString());
                    continue;
                }
                if ("verbosity".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.verbosity = Verbosity.fromString(reader.getString());
                    continue;
                }
                if ("operationNameFormat".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.operationNameFormat = OperationNameFormat.fromString(reader.getString());
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    deserializedDiagnosticContractUpdateProperties.metrics = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticContractUpdateProperties;
        });
    }
}

