/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;
import java.io.IOException;

public final class GatewayContractProperties
implements JsonSerializable<GatewayContractProperties> {
    private ResourceLocationDataContract locationData;
    private String description;

    public ResourceLocationDataContract locationData() {
        return this.locationData;
    }

    public GatewayContractProperties withLocationData(ResourceLocationDataContract locationData) {
        this.locationData = locationData;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GatewayContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.locationData() != null) {
            this.locationData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("locationData", (JsonSerializable)this.locationData);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static GatewayContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayContractProperties)jsonReader.readObject(reader -> {
            GatewayContractProperties deserializedGatewayContractProperties = new GatewayContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locationData".equals(fieldName)) {
                    deserializedGatewayContractProperties.locationData = ResourceLocationDataContract.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGatewayContractProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayContractProperties;
        });
    }
}

