/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderBaseParameters;
import com.azure.resourcemanager.apimanagement.models.IdentityProviderType;
import java.io.IOException;
import java.util.List;

public final class IdentityProviderContractProperties
extends IdentityProviderBaseParameters {
    private String clientId;
    private String clientSecret;
    private static final ClientLogger LOGGER = new ClientLogger(IdentityProviderContractProperties.class);

    public String clientId() {
        return this.clientId;
    }

    public IdentityProviderContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public IdentityProviderContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public IdentityProviderContractProperties withType(IdentityProviderType type) {
        super.withType(type);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withSigninTenant(String signinTenant) {
        super.withSigninTenant(signinTenant);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withAllowedTenants(List<String> allowedTenants) {
        super.withAllowedTenants(allowedTenants);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withAuthority(String authority) {
        super.withAuthority(authority);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withSignupPolicyName(String signupPolicyName) {
        super.withSignupPolicyName(signupPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withSigninPolicyName(String signinPolicyName) {
        super.withSigninPolicyName(signinPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withProfileEditingPolicyName(String profileEditingPolicyName) {
        super.withProfileEditingPolicyName(profileEditingPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withPasswordResetPolicyName(String passwordResetPolicyName) {
        super.withPasswordResetPolicyName(passwordResetPolicyName);
        return this;
    }

    @Override
    public IdentityProviderContractProperties withClientLibrary(String clientLibrary) {
        super.withClientLibrary(clientLibrary);
        return this;
    }

    @Override
    public void validate() {
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model IdentityProviderContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("signinTenant", this.signinTenant());
        jsonWriter.writeArrayField("allowedTenants", this.allowedTenants(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("authority", this.authority());
        jsonWriter.writeStringField("signupPolicyName", this.signupPolicyName());
        jsonWriter.writeStringField("signinPolicyName", this.signinPolicyName());
        jsonWriter.writeStringField("profileEditingPolicyName", this.profileEditingPolicyName());
        jsonWriter.writeStringField("passwordResetPolicyName", this.passwordResetPolicyName());
        jsonWriter.writeStringField("clientLibrary", this.clientLibrary());
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static IdentityProviderContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProviderContractProperties)jsonReader.readObject(reader -> {
            IdentityProviderContractProperties deserializedIdentityProviderContractProperties = new IdentityProviderContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withType(IdentityProviderType.fromString(reader.getString()));
                    continue;
                }
                if ("signinTenant".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withSigninTenant(reader.getString());
                    continue;
                }
                if ("allowedTenants".equals(fieldName)) {
                    List allowedTenants = reader.readArray(reader1 -> reader1.getString());
                    deserializedIdentityProviderContractProperties.withAllowedTenants(allowedTenants);
                    continue;
                }
                if ("authority".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withAuthority(reader.getString());
                    continue;
                }
                if ("signupPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withSignupPolicyName(reader.getString());
                    continue;
                }
                if ("signinPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withSigninPolicyName(reader.getString());
                    continue;
                }
                if ("profileEditingPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withProfileEditingPolicyName(reader.getString());
                    continue;
                }
                if ("passwordResetPolicyName".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withPasswordResetPolicyName(reader.getString());
                    continue;
                }
                if ("clientLibrary".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.withClientLibrary(reader.getString());
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedIdentityProviderContractProperties.clientSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProviderContractProperties;
        });
    }
}

