/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.LoggerContractProperties;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import java.io.IOException;
import java.util.Map;

public final class LoggerContractInner
extends ProxyResource {
    private LoggerContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private LoggerContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public LoggerType loggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().loggerType();
    }

    public LoggerContractInner withLoggerType(LoggerType loggerType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerContractProperties();
        }
        this.innerProperties().withLoggerType(loggerType);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public LoggerContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Map<String, String> credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public LoggerContractInner withCredentials(Map<String, String> credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerContractProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public Boolean isBuffered() {
        return this.innerProperties() == null ? null : this.innerProperties().isBuffered();
    }

    public LoggerContractInner withIsBuffered(Boolean isBuffered) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerContractProperties();
        }
        this.innerProperties().withIsBuffered(isBuffered);
        return this;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public LoggerContractInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoggerContractProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LoggerContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (LoggerContractInner)((Object)jsonReader.readObject(reader -> {
            LoggerContractInner deserializedLoggerContractInner = new LoggerContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLoggerContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLoggerContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLoggerContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLoggerContractInner.innerProperties = LoggerContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggerContractInner;
        }));
    }
}

