/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AsyncOperationStatus;
import com.azure.resourcemanager.apimanagement.models.ErrorResponseBody;
import com.azure.resourcemanager.apimanagement.models.OperationResultLogItemContract;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class OperationResultContractProperties
implements JsonSerializable<OperationResultContractProperties> {
    private String id;
    private AsyncOperationStatus status;
    private OffsetDateTime started;
    private OffsetDateTime updated;
    private String resultInfo;
    private ErrorResponseBody error;
    private List<OperationResultLogItemContract> actionLog;

    public String id() {
        return this.id;
    }

    public OperationResultContractProperties withId(String id) {
        this.id = id;
        return this;
    }

    public AsyncOperationStatus status() {
        return this.status;
    }

    public OperationResultContractProperties withStatus(AsyncOperationStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime started() {
        return this.started;
    }

    public OperationResultContractProperties withStarted(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    public OffsetDateTime updated() {
        return this.updated;
    }

    public OperationResultContractProperties withUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public String resultInfo() {
        return this.resultInfo;
    }

    public OperationResultContractProperties withResultInfo(String resultInfo) {
        this.resultInfo = resultInfo;
        return this;
    }

    public ErrorResponseBody error() {
        return this.error;
    }

    public OperationResultContractProperties withError(ErrorResponseBody error) {
        this.error = error;
        return this;
    }

    public List<OperationResultLogItemContract> actionLog() {
        return this.actionLog;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.actionLog() != null) {
            this.actionLog().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("started", this.started == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.started));
        jsonWriter.writeStringField("updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        jsonWriter.writeStringField("resultInfo", this.resultInfo);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationResultContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResultContractProperties)jsonReader.readObject(reader -> {
            OperationResultContractProperties deserializedOperationResultContractProperties = new OperationResultContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOperationResultContractProperties.id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationResultContractProperties.status = AsyncOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("started".equals(fieldName)) {
                    deserializedOperationResultContractProperties.started = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedOperationResultContractProperties.updated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resultInfo".equals(fieldName)) {
                    deserializedOperationResultContractProperties.resultInfo = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationResultContractProperties.error = ErrorResponseBody.fromJson(reader);
                    continue;
                }
                if ("actionLog".equals(fieldName)) {
                    List actionLog;
                    deserializedOperationResultContractProperties.actionLog = actionLog = reader.readArray(reader1 -> OperationResultLogItemContract.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResultContractProperties;
        });
    }
}

