/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.RegistrationDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.SubscriptionsDelegationSettingsProperties;
import com.azure.resourcemanager.apimanagement.models.TermsOfServiceProperties;
import java.io.IOException;

public final class PortalSettingsContractProperties
implements JsonSerializable<PortalSettingsContractProperties> {
    private String url;
    private String validationKey;
    private SubscriptionsDelegationSettingsProperties subscriptions;
    private RegistrationDelegationSettingsProperties userRegistration;
    private Boolean enabled;
    private TermsOfServiceProperties termsOfService;

    public String url() {
        return this.url;
    }

    public PortalSettingsContractProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public String validationKey() {
        return this.validationKey;
    }

    public PortalSettingsContractProperties withValidationKey(String validationKey) {
        this.validationKey = validationKey;
        return this;
    }

    public SubscriptionsDelegationSettingsProperties subscriptions() {
        return this.subscriptions;
    }

    public PortalSettingsContractProperties withSubscriptions(SubscriptionsDelegationSettingsProperties subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public RegistrationDelegationSettingsProperties userRegistration() {
        return this.userRegistration;
    }

    public PortalSettingsContractProperties withUserRegistration(RegistrationDelegationSettingsProperties userRegistration) {
        this.userRegistration = userRegistration;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public PortalSettingsContractProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TermsOfServiceProperties termsOfService() {
        return this.termsOfService;
    }

    public PortalSettingsContractProperties withTermsOfService(TermsOfServiceProperties termsOfService) {
        this.termsOfService = termsOfService;
        return this;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().validate();
        }
        if (this.userRegistration() != null) {
            this.userRegistration().validate();
        }
        if (this.termsOfService() != null) {
            this.termsOfService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("validationKey", this.validationKey);
        jsonWriter.writeJsonField("subscriptions", (JsonSerializable)this.subscriptions);
        jsonWriter.writeJsonField("userRegistration", (JsonSerializable)this.userRegistration);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("termsOfService", (JsonSerializable)this.termsOfService);
        return jsonWriter.writeEndObject();
    }

    public static PortalSettingsContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PortalSettingsContractProperties)jsonReader.readObject(reader -> {
            PortalSettingsContractProperties deserializedPortalSettingsContractProperties = new PortalSettingsContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.url = reader.getString();
                    continue;
                }
                if ("validationKey".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.validationKey = reader.getString();
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.subscriptions = SubscriptionsDelegationSettingsProperties.fromJson(reader);
                    continue;
                }
                if ("userRegistration".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.userRegistration = RegistrationDelegationSettingsProperties.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("termsOfService".equals(fieldName)) {
                    deserializedPortalSettingsContractProperties.termsOfService = TermsOfServiceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPortalSettingsContractProperties;
        });
    }
}

