/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SubscriptionState;
import java.io.IOException;

public final class SubscriptionCreateParameterProperties
implements JsonSerializable<SubscriptionCreateParameterProperties> {
    private String ownerId;
    private String scope;
    private String displayName;
    private String primaryKey;
    private String secondaryKey;
    private SubscriptionState state;
    private Boolean allowTracing;
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionCreateParameterProperties.class);

    public String ownerId() {
        return this.ownerId;
    }

    public SubscriptionCreateParameterProperties withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public SubscriptionCreateParameterProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public SubscriptionCreateParameterProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String primaryKey() {
        return this.primaryKey;
    }

    public SubscriptionCreateParameterProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public String secondaryKey() {
        return this.secondaryKey;
    }

    public SubscriptionCreateParameterProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    public SubscriptionState state() {
        return this.state;
    }

    public SubscriptionCreateParameterProperties withState(SubscriptionState state) {
        this.state = state;
        return this;
    }

    public Boolean allowTracing() {
        return this.allowTracing;
    }

    public SubscriptionCreateParameterProperties withAllowTracing(Boolean allowTracing) {
        this.allowTracing = allowTracing;
        return this;
    }

    public void validate() {
        if (this.scope() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scope in model SubscriptionCreateParameterProperties"));
        }
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model SubscriptionCreateParameterProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("ownerId", this.ownerId);
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("allowTracing", this.allowTracing);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionCreateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionCreateParameterProperties)jsonReader.readObject(reader -> {
            SubscriptionCreateParameterProperties deserializedSubscriptionCreateParameterProperties = new SubscriptionCreateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.scope = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.displayName = reader.getString();
                    continue;
                }
                if ("ownerId".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.ownerId = reader.getString();
                    continue;
                }
                if ("primaryKey".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.primaryKey = reader.getString();
                    continue;
                }
                if ("secondaryKey".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.secondaryKey = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.state = SubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("allowTracing".equals(fieldName)) {
                    deserializedSubscriptionCreateParameterProperties.allowTracing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionCreateParameterProperties;
        });
    }
}

