/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.AccessInformationContract;
import com.azure.resourcemanager.apimanagement.models.AccessInformationCreateParameters;
import com.azure.resourcemanager.apimanagement.models.AccessInformationSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AccessInformationUpdateParameters;

public final class AccessInformationContractImpl
implements AccessInformationContract,
AccessInformationContract.Definition,
AccessInformationContract.Update {
    private AccessInformationContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private AccessIdName accessName;
    private String createIfMatch;
    private AccessInformationCreateParameters createParameters;
    private String updateIfMatch;
    private AccessInformationUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String idPropertiesId() {
        return this.innerModel().idPropertiesId();
    }

    @Override
    public String principalId() {
        return this.innerModel().principalId();
    }

    @Override
    public Boolean enabled() {
        return this.innerModel().enabled();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AccessInformationContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccessInformationContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public AccessInformationContract create() {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().createWithResponse(this.resourceGroupName, this.serviceName, this.accessName, this.createIfMatch, this.createParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public AccessInformationContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().createWithResponse(this.resourceGroupName, this.serviceName, this.accessName, this.createIfMatch, this.createParameters, context).getValue();
        return this;
    }

    AccessInformationContractImpl(AccessIdName name, ApiManagementManager serviceManager) {
        this.innerObject = new AccessInformationContractInner();
        this.serviceManager = serviceManager;
        this.accessName = name;
        this.createIfMatch = null;
        this.createParameters = new AccessInformationCreateParameters();
    }

    @Override
    public AccessInformationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new AccessInformationUpdateParameters();
        return this;
    }

    @Override
    public AccessInformationContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().updateWithResponse(this.resourceGroupName, this.serviceName, this.accessName, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public AccessInformationContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().updateWithResponse(this.resourceGroupName, this.serviceName, this.accessName, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    AccessInformationContractImpl(AccessInformationContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.accessName = AccessIdName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tenant"));
    }

    @Override
    public AccessInformationContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().getWithResponse(this.resourceGroupName, this.serviceName, this.accessName, Context.NONE).getValue();
        return this;
    }

    @Override
    public AccessInformationContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTenantAccess().getWithResponse(this.resourceGroupName, this.serviceName, this.accessName, context).getValue();
        return this;
    }

    @Override
    public Response<Void> regeneratePrimaryKeyWithResponse(Context context) {
        return this.serviceManager.tenantAccess().regeneratePrimaryKeyWithResponse(this.resourceGroupName, this.serviceName, this.accessName, context);
    }

    @Override
    public void regeneratePrimaryKey() {
        this.serviceManager.tenantAccess().regeneratePrimaryKey(this.resourceGroupName, this.serviceName, this.accessName);
    }

    @Override
    public Response<Void> regenerateSecondaryKeyWithResponse(Context context) {
        return this.serviceManager.tenantAccess().regenerateSecondaryKeyWithResponse(this.resourceGroupName, this.serviceName, this.accessName, context);
    }

    @Override
    public void regenerateSecondaryKey() {
        this.serviceManager.tenantAccess().regenerateSecondaryKey(this.resourceGroupName, this.serviceName, this.accessName);
    }

    @Override
    public Response<AccessInformationSecretsContract> listSecretsWithResponse(Context context) {
        return this.serviceManager.tenantAccess().listSecretsWithResponse(this.resourceGroupName, this.serviceName, this.accessName, context);
    }

    @Override
    public AccessInformationSecretsContract listSecrets() {
        return this.serviceManager.tenantAccess().listSecrets(this.resourceGroupName, this.serviceName, this.accessName);
    }

    @Override
    public AccessInformationContractImpl withPrincipalId(String principalId) {
        this.createParameters.withPrincipalId(principalId);
        return this;
    }

    @Override
    public AccessInformationContractImpl withPrimaryKey(String primaryKey) {
        this.createParameters.withPrimaryKey(primaryKey);
        return this;
    }

    @Override
    public AccessInformationContractImpl withSecondaryKey(String secondaryKey) {
        this.createParameters.withSecondaryKey(secondaryKey);
        return this;
    }

    @Override
    public AccessInformationContractImpl withEnabled(Boolean enabled) {
        if (this.isInCreateMode()) {
            this.createParameters.withEnabled(enabled);
            return this;
        }
        this.updateParameters.withEnabled(enabled);
        return this;
    }

    @Override
    public AccessInformationContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

