/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.AllPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AllPoliciesContractInner;
import com.azure.resourcemanager.apimanagement.implementation.AllPoliciesContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AllPolicies;
import com.azure.resourcemanager.apimanagement.models.AllPoliciesContract;

public final class AllPoliciesImpl
implements AllPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(AllPoliciesImpl.class);
    private final AllPoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public AllPoliciesImpl(AllPoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AllPoliciesContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AllPoliciesContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllPoliciesContractImpl((AllPoliciesContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AllPoliciesContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<AllPoliciesContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllPoliciesContractImpl((AllPoliciesContractInner)((Object)inner1), this.manager()));
    }

    private AllPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

