/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiGatewaysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementGatewayResourceImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiGateways;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayResource;

public final class ApiGatewaysImpl
implements ApiGateways {
    private static final ClientLogger LOGGER = new ClientLogger(ApiGatewaysImpl.class);
    private final ApiGatewaysClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiGatewaysImpl(ApiGatewaysClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ApiManagementGatewayResource> getByResourceGroupWithResponse(String resourceGroupName, String gatewayName, Context context) {
        Response<ApiManagementGatewayResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, gatewayName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiManagementGatewayResourceImpl((ApiManagementGatewayResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ApiManagementGatewayResource getByResourceGroup(String resourceGroupName, String gatewayName) {
        ApiManagementGatewayResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, gatewayName);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementGatewayResource deleteByResourceGroup(String resourceGroupName, String gatewayName) {
        ApiManagementGatewayResourceInner inner = this.serviceClient().delete(resourceGroupName, gatewayName);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ApiManagementGatewayResource delete(String resourceGroupName, String gatewayName, Context context) {
        ApiManagementGatewayResourceInner inner = this.serviceClient().delete(resourceGroupName, gatewayName, context);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ApiManagementGatewayResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayResourceImpl((ApiManagementGatewayResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementGatewayResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayResourceImpl((ApiManagementGatewayResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementGatewayResource> list() {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayResourceImpl((ApiManagementGatewayResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiManagementGatewayResource> list(Context context) {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementGatewayResourceImpl((ApiManagementGatewayResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiManagementGatewayResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return (ApiManagementGatewayResource)this.getByResourceGroupWithResponse(resourceGroupName, gatewayName, Context.NONE).getValue();
    }

    @Override
    public Response<ApiManagementGatewayResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, gatewayName, context);
    }

    @Override
    public ApiManagementGatewayResource deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.delete(resourceGroupName, gatewayName, Context.NONE);
    }

    @Override
    public ApiManagementGatewayResource deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.delete(resourceGroupName, gatewayName, context);
    }

    private ApiGatewaysClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementGatewayResourceImpl define(String name) {
        return new ApiManagementGatewayResourceImpl(name, this.manager());
    }
}

