/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayConfigConnectionResource;
import java.util.Collections;
import java.util.List;

public final class ApiManagementGatewayConfigConnectionResourceImpl
implements ApiManagementGatewayConfigConnectionResource,
ApiManagementGatewayConfigConnectionResource.Definition,
ApiManagementGatewayConfigConnectionResource.Update {
    private ApiManagementGatewayConfigConnectionResourceInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String gatewayName;
    private String configConnectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String sourceId() {
        return this.innerModel().sourceId();
    }

    @Override
    public String defaultHostname() {
        return this.innerModel().defaultHostname();
    }

    @Override
    public List<String> hostnames() {
        List<String> inner = this.innerModel().hostnames();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceImpl withExistingGateway(String resourceGroupName, String gatewayName) {
        this.resourceGroupName = resourceGroupName;
        this.gatewayName = gatewayName;
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource create() {
        this.innerObject = this.serviceManager.serviceClient().getApiGatewayConfigConnections().createOrUpdate(this.resourceGroupName, this.gatewayName, this.configConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiGatewayConfigConnections().createOrUpdate(this.resourceGroupName, this.gatewayName, this.configConnectionName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayConfigConnectionResourceImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiManagementGatewayConfigConnectionResourceInner();
        this.serviceManager = serviceManager;
        this.configConnectionName = name;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceImpl update() {
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiGatewayConfigConnections().createOrUpdate(this.resourceGroupName, this.gatewayName, this.configConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiGatewayConfigConnections().createOrUpdate(this.resourceGroupName, this.gatewayName, this.configConnectionName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayConfigConnectionResourceImpl(ApiManagementGatewayConfigConnectionResourceInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.gatewayName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
        this.configConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configConnections");
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource refresh() {
        this.innerObject = (ApiManagementGatewayConfigConnectionResourceInner)((Object)this.serviceManager.serviceClient().getApiGatewayConfigConnections().getWithResponse(this.resourceGroupName, this.gatewayName, this.configConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResource refresh(Context context) {
        this.innerObject = (ApiManagementGatewayConfigConnectionResourceInner)((Object)this.serviceManager.serviceClient().getApiGatewayConfigConnections().getWithResponse(this.resourceGroupName, this.gatewayName, this.configConnectionName, context).getValue());
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceImpl withSourceId(String sourceId) {
        this.innerModel().withSourceId(sourceId);
        return this;
    }

    @Override
    public ApiManagementGatewayConfigConnectionResourceImpl withHostnames(List<String> hostnames) {
        this.innerModel().withHostnames(hostnames);
        return this;
    }
}

