/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementGatewaySkusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayResourceSkuResultInner;
import com.azure.resourcemanager.apimanagement.implementation.GatewayResourceSkuResultImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkus;
import com.azure.resourcemanager.apimanagement.models.GatewayResourceSkuResult;

public final class ApiManagementGatewaySkusImpl
implements ApiManagementGatewaySkus {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementGatewaySkusImpl.class);
    private final ApiManagementGatewaySkusClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiManagementGatewaySkusImpl(ApiManagementGatewaySkusClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GatewayResourceSkuResult> listAvailableSkus(String resourceGroupName, String gatewayName) {
        PagedIterable<GatewayResourceSkuResultInner> inner = this.serviceClient().listAvailableSkus(resourceGroupName, gatewayName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayResourceSkuResultImpl((GatewayResourceSkuResultInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<GatewayResourceSkuResult> listAvailableSkus(String resourceGroupName, String gatewayName, Context context) {
        PagedIterable<GatewayResourceSkuResultInner> inner = this.serviceClient().listAvailableSkus(resourceGroupName, gatewayName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayResourceSkuResultImpl((GatewayResourceSkuResultInner)inner1, this.manager()));
    }

    private ApiManagementGatewaySkusClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

