/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceResourceInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceApplyNetworkConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBackupRestoreParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetSsoTokenResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceIdentity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceResource;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.DeveloperPortalStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.LegacyPortalStatus;
import com.azure.resourcemanager.apimanagement.models.MigrateToStv2Contract;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ApiManagementServiceResourceImpl
implements ApiManagementServiceResource,
ApiManagementServiceResource.Definition,
ApiManagementServiceResource.Update {
    private ApiManagementServiceResourceInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private ApiManagementServiceUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ApiManagementServiceSkuProperties sku() {
        return this.innerModel().sku();
    }

    @Override
    public ApiManagementServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String publisherEmail() {
        return this.innerModel().publisherEmail();
    }

    @Override
    public String publisherName() {
        return this.innerModel().publisherName();
    }

    @Override
    public String notificationSenderEmail() {
        return this.innerModel().notificationSenderEmail();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String targetProvisioningState() {
        return this.innerModel().targetProvisioningState();
    }

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.innerModel().createdAtUtc();
    }

    @Override
    public String gatewayUrl() {
        return this.innerModel().gatewayUrl();
    }

    @Override
    public String gatewayRegionalUrl() {
        return this.innerModel().gatewayRegionalUrl();
    }

    @Override
    public String portalUrl() {
        return this.innerModel().portalUrl();
    }

    @Override
    public String managementApiUrl() {
        return this.innerModel().managementApiUrl();
    }

    @Override
    public String scmUrl() {
        return this.innerModel().scmUrl();
    }

    @Override
    public String developerPortalUrl() {
        return this.innerModel().developerPortalUrl();
    }

    @Override
    public List<HostnameConfiguration> hostnameConfigurations() {
        List<HostnameConfiguration> inner = this.innerModel().hostnameConfigurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> publicIpAddresses() {
        List<String> inner = this.innerModel().publicIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> privateIpAddresses() {
        List<String> inner = this.innerModel().privateIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String publicIpAddressId() {
        return this.innerModel().publicIpAddressId();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public ConfigurationApi configurationApi() {
        return this.innerModel().configurationApi();
    }

    @Override
    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerModel().virtualNetworkConfiguration();
    }

    @Override
    public List<AdditionalLocation> additionalLocations() {
        List<AdditionalLocation> inner = this.innerModel().additionalLocations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> customProperties() {
        Map<String, String> inner = this.innerModel().customProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<CertificateConfiguration> certificates() {
        List<CertificateConfiguration> inner = this.innerModel().certificates();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean enableClientCertificate() {
        return this.innerModel().enableClientCertificate();
    }

    @Override
    public NatGatewayState natGatewayState() {
        return this.innerModel().natGatewayState();
    }

    @Override
    public List<String> outboundPublicIpAddresses() {
        List<String> inner = this.innerModel().outboundPublicIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean disableGateway() {
        return this.innerModel().disableGateway();
    }

    @Override
    public VirtualNetworkType virtualNetworkType() {
        return this.innerModel().virtualNetworkType();
    }

    @Override
    public ApiVersionConstraint apiVersionConstraint() {
        return this.innerModel().apiVersionConstraint();
    }

    @Override
    public Boolean restore() {
        return this.innerModel().restore();
    }

    @Override
    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        List<RemotePrivateEndpointConnectionWrapper> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public PlatformVersion platformVersion() {
        return this.innerModel().platformVersion();
    }

    @Override
    public LegacyPortalStatus legacyPortalStatus() {
        return this.innerModel().legacyPortalStatus();
    }

    @Override
    public DeveloperPortalStatus developerPortalStatus() {
        return this.innerModel().developerPortalStatus();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiManagementServiceResourceInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiManagementServiceResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ApiManagementServiceResource create() {
        this.innerObject = this.serviceManager.serviceClient().getApiManagementServices().createOrUpdate(this.resourceGroupName, this.serviceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ApiManagementServiceResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiManagementServices().createOrUpdate(this.resourceGroupName, this.serviceName, this.innerModel(), context);
        return this;
    }

    ApiManagementServiceResourceImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiManagementServiceResourceInner();
        this.serviceManager = serviceManager;
        this.serviceName = name;
    }

    @Override
    public ApiManagementServiceResourceImpl update() {
        this.updateParameters = new ApiManagementServiceUpdateParameters();
        return this;
    }

    @Override
    public ApiManagementServiceResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiManagementServices().update(this.resourceGroupName, this.serviceName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public ApiManagementServiceResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiManagementServices().update(this.resourceGroupName, this.serviceName, this.updateParameters, context);
        return this;
    }

    ApiManagementServiceResourceImpl(ApiManagementServiceResourceInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
    }

    @Override
    public ApiManagementServiceResource refresh() {
        this.innerObject = (ApiManagementServiceResourceInner)((Object)this.serviceManager.serviceClient().getApiManagementServices().getByResourceGroupWithResponse(this.resourceGroupName, this.serviceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApiManagementServiceResource refresh(Context context) {
        this.innerObject = (ApiManagementServiceResourceInner)((Object)this.serviceManager.serviceClient().getApiManagementServices().getByResourceGroupWithResponse(this.resourceGroupName, this.serviceName, context).getValue());
        return this;
    }

    @Override
    public ApiManagementServiceResource backup(ApiManagementServiceBackupRestoreParameters parameters) {
        return this.serviceManager.apiManagementServices().backup(this.resourceGroupName, this.serviceName, parameters);
    }

    @Override
    public ApiManagementServiceResource backup(ApiManagementServiceBackupRestoreParameters parameters, Context context) {
        return this.serviceManager.apiManagementServices().backup(this.resourceGroupName, this.serviceName, parameters, context);
    }

    @Override
    public ApiManagementServiceResource migrateToStv2() {
        return this.serviceManager.apiManagementServices().migrateToStv2(this.resourceGroupName, this.serviceName);
    }

    @Override
    public ApiManagementServiceResource migrateToStv2(MigrateToStv2Contract parameters, Context context) {
        return this.serviceManager.apiManagementServices().migrateToStv2(this.resourceGroupName, this.serviceName, parameters, context);
    }

    @Override
    public Response<ApiManagementServiceGetSsoTokenResult> getSsoTokenWithResponse(Context context) {
        return this.serviceManager.apiManagementServices().getSsoTokenWithResponse(this.resourceGroupName, this.serviceName, context);
    }

    @Override
    public ApiManagementServiceGetSsoTokenResult getSsoToken() {
        return this.serviceManager.apiManagementServices().getSsoToken(this.resourceGroupName, this.serviceName);
    }

    @Override
    public ApiManagementServiceResource applyNetworkConfigurationUpdates() {
        return this.serviceManager.apiManagementServices().applyNetworkConfigurationUpdates(this.resourceGroupName, this.serviceName);
    }

    @Override
    public ApiManagementServiceResource applyNetworkConfigurationUpdates(ApiManagementServiceApplyNetworkConfigurationParameters parameters, Context context) {
        return this.serviceManager.apiManagementServices().applyNetworkConfigurationUpdates(this.resourceGroupName, this.serviceName, parameters, context);
    }

    @Override
    public ApiManagementServiceResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withSku(ApiManagementServiceSkuProperties sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withPublisherEmail(String publisherEmail) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublisherEmail(publisherEmail);
            return this;
        }
        this.updateParameters.withPublisherEmail(publisherEmail);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withPublisherName(String publisherName) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublisherName(publisherName);
            return this;
        }
        this.updateParameters.withPublisherName(publisherName);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags((Map)tags);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withIdentity(ApiManagementServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withZones(List<String> zones) {
        if (this.isInCreateMode()) {
            this.innerModel().withZones(zones);
            return this;
        }
        this.updateParameters.withZones(zones);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withNotificationSenderEmail(String notificationSenderEmail) {
        if (this.isInCreateMode()) {
            this.innerModel().withNotificationSenderEmail(notificationSenderEmail);
            return this;
        }
        this.updateParameters.withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        if (this.isInCreateMode()) {
            this.innerModel().withHostnameConfigurations(hostnameConfigurations);
            return this;
        }
        this.updateParameters.withHostnameConfigurations(hostnameConfigurations);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withPublicIpAddressId(String publicIpAddressId) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicIpAddressId(publicIpAddressId);
            return this;
        }
        this.updateParameters.withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withConfigurationApi(ConfigurationApi configurationApi) {
        if (this.isInCreateMode()) {
            this.innerModel().withConfigurationApi(configurationApi);
            return this;
        }
        this.updateParameters.withConfigurationApi(configurationApi);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
            return this;
        }
        this.updateParameters.withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdditionalLocations(additionalLocations);
            return this;
        }
        this.updateParameters.withAdditionalLocations(additionalLocations);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withCustomProperties(Map<String, String> customProperties) {
        if (this.isInCreateMode()) {
            this.innerModel().withCustomProperties(customProperties);
            return this;
        }
        this.updateParameters.withCustomProperties(customProperties);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withCertificates(List<CertificateConfiguration> certificates) {
        if (this.isInCreateMode()) {
            this.innerModel().withCertificates(certificates);
            return this;
        }
        this.updateParameters.withCertificates(certificates);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withEnableClientCertificate(Boolean enableClientCertificate) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableClientCertificate(enableClientCertificate);
            return this;
        }
        this.updateParameters.withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withNatGatewayState(NatGatewayState natGatewayState) {
        if (this.isInCreateMode()) {
            this.innerModel().withNatGatewayState(natGatewayState);
            return this;
        }
        this.updateParameters.withNatGatewayState(natGatewayState);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withDisableGateway(Boolean disableGateway) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisableGateway(disableGateway);
            return this;
        }
        this.updateParameters.withDisableGateway(disableGateway);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.isInCreateMode()) {
            this.innerModel().withVirtualNetworkType(virtualNetworkType);
            return this;
        }
        this.updateParameters.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        if (this.isInCreateMode()) {
            this.innerModel().withApiVersionConstraint(apiVersionConstraint);
            return this;
        }
        this.updateParameters.withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withRestore(Boolean restore) {
        if (this.isInCreateMode()) {
            this.innerModel().withRestore(restore);
            return this;
        }
        this.updateParameters.withRestore(restore);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        if (this.isInCreateMode()) {
            this.innerModel().withPrivateEndpointConnections(privateEndpointConnections);
            return this;
        }
        this.updateParameters.withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withLegacyPortalStatus(LegacyPortalStatus legacyPortalStatus) {
        if (this.isInCreateMode()) {
            this.innerModel().withLegacyPortalStatus(legacyPortalStatus);
            return this;
        }
        this.updateParameters.withLegacyPortalStatus(legacyPortalStatus);
        return this;
    }

    @Override
    public ApiManagementServiceResourceImpl withDeveloperPortalStatus(DeveloperPortalStatus developerPortalStatus) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeveloperPortalStatus(developerPortalStatus);
            return this;
        }
        this.updateParameters.withDeveloperPortalStatus(developerPortalStatus);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

