/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApiOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.OperationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiOperations;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.OperationContract;

public final class ApiOperationsImpl
implements ApiOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ApiOperationsImpl.class);
    private final ApiOperationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApiOperationsImpl(ApiOperationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<OperationContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl((OperationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String apiId, String filter, Integer top, Integer skip, String tags, Context context) {
        PagedIterable<OperationContractInner> inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, tags, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl((OperationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApiOperationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String operationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, operationId);
    }

    @Override
    public Response<OperationContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, Context context) {
        ApiOperationsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationContract get(String resourceGroupName, String serviceName, String apiId, String operationId) {
        OperationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, operationId);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, operationId, ifMatch);
    }

    @Override
    public OperationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return (OperationContract)this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, Context.NONE).getValue();
    }

    @Override
    public Response<OperationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, context);
    }

    private ApiOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public OperationContractImpl define(String name) {
        return new OperationContractImpl(name, this.manager());
    }
}

