/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiVersionSetContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContract;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;

public final class ApiVersionSetContractImpl
implements ApiVersionSetContract,
ApiVersionSetContract.Definition,
ApiVersionSetContract.Update {
    private ApiVersionSetContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String versionSetId;
    private String createIfMatch;
    private String updateIfMatch;
    private ApiVersionSetUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public VersioningScheme versioningScheme() {
        return this.innerModel().versioningScheme();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String versionQueryName() {
        return this.innerModel().versionQueryName();
    }

    @Override
    public String versionHeaderName() {
        return this.innerModel().versionHeaderName();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiVersionSetContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiVersionSetContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ApiVersionSetContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersionSetContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    ApiVersionSetContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new ApiVersionSetContractInner();
        this.serviceManager = serviceManager;
        this.versionSetId = name;
        this.createIfMatch = null;
    }

    @Override
    public ApiVersionSetContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ApiVersionSetUpdateParameters();
        return this;
    }

    @Override
    public ApiVersionSetContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().updateWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersionSetContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().updateWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    ApiVersionSetContractImpl(ApiVersionSetContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.versionSetId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiVersionSets");
    }

    @Override
    public ApiVersionSetContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().getWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersionSetContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersionSets().getWithResponse(this.resourceGroupName, this.serviceName, this.versionSetId, context).getValue();
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withVersioningScheme(VersioningScheme versioningScheme) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersioningScheme(versioningScheme);
            return this;
        }
        this.updateParameters.withVersioningScheme(versioningScheme);
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withVersionQueryName(String versionQueryName) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersionQueryName(versionQueryName);
            return this;
        }
        this.updateParameters.withVersionQueryName(versionQueryName);
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withVersionHeaderName(String versionHeaderName) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersionHeaderName(versionHeaderName);
            return this;
        }
        this.updateParameters.withVersionHeaderName(versionHeaderName);
        return this;
    }

    @Override
    public ApiVersionSetContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

