/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ApisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.TagResourceContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.implementation.TagResourceContractImpl;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.Apis;
import com.azure.resourcemanager.apimanagement.models.ApisGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApisGetResponse;
import com.azure.resourcemanager.apimanagement.models.TagResourceContract;

public final class ApisImpl
implements Apis {
    private static final ClientLogger LOGGER = new ClientLogger(ApisImpl.class);
    private final ApisClient innerClient;
    private final ApiManagementManager serviceManager;

    public ApisImpl(ApisClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, String tags, Boolean expandApiVersionSet, Context context) {
        PagedIterable<ApiContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, tags, expandApiVersionSet, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiContractImpl((ApiContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ApisGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId);
    }

    @Override
    public Response<ApiContract> getWithResponse(String resourceGroupName, String serviceName, String apiId, Context context) {
        ApisGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiContract get(String resourceGroupName, String serviceName, String apiId) {
        ApiContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new ApiContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, ifMatch);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String apiId, String ifMatch, Boolean deleteRevisions, Context context) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, ifMatch, deleteRevisions, context);
    }

    @Override
    public PagedIterable<TagResourceContract> listByTags(String resourceGroupName, String serviceName) {
        PagedIterable<TagResourceContractInner> inner = this.serviceClient().listByTags(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagResourceContractImpl((TagResourceContractInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<TagResourceContract> listByTags(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Boolean includeNotTaggedApis, Context context) {
        PagedIterable<TagResourceContractInner> inner = this.serviceClient().listByTags(resourceGroupName, serviceName, filter, top, skip, includeNotTaggedApis, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagResourceContractImpl((TagResourceContractInner)inner1, this.manager()));
    }

    @Override
    public ApiContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        return (ApiContract)this.getWithResponse(resourceGroupName, serviceName, apiId, Context.NONE).getValue();
    }

    @Override
    public Response<ApiContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String localIfMatch = null;
        Boolean localDeleteRevisions = null;
        this.delete(resourceGroupName, serviceName, apiId, localIfMatch, localDeleteRevisions, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Boolean deleteRevisions, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        this.delete(resourceGroupName, serviceName, apiId, ifMatch, deleteRevisions, context);
    }

    private ApisClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiContractImpl define(String name) {
        return new ApiContractImpl(name, this.manager());
    }
}

