/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicyContract;
import java.util.Collections;
import java.util.List;

public final class AuthorizationAccessPolicyContractImpl
implements AuthorizationAccessPolicyContract,
AuthorizationAccessPolicyContract.Definition,
AuthorizationAccessPolicyContract.Update {
    private AuthorizationAccessPolicyContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String authorizationProviderId;
    private String authorizationId;
    private String authorizationAccessPolicyId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public List<String> appIds() {
        List<String> inner = this.innerModel().appIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public String objectId() {
        return this.innerModel().objectId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AuthorizationAccessPolicyContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl withExistingAuthorization(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.authorizationProviderId = authorizationProviderId;
        this.authorizationId = authorizationId;
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContract create() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    AuthorizationAccessPolicyContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationAccessPolicyContractInner();
        this.serviceManager = serviceManager;
        this.authorizationAccessPolicyId = name;
        this.createIfMatch = null;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    AuthorizationAccessPolicyContractImpl(AuthorizationAccessPolicyContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationProviders");
        this.authorizationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizations");
        this.authorizationAccessPolicyId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "accessPolicies");
    }

    @Override
    public AuthorizationAccessPolicyContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizationAccessPolicies().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.authorizationAccessPolicyId, context).getValue();
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl withAppIds(List<String> appIds) {
        this.innerModel().withAppIds(appIds);
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl withTenantId(String tenantId) {
        this.innerModel().withTenantId(tenantId);
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl withObjectId(String objectId) {
        this.innerModel().withObjectId(objectId);
        return this;
    }

    @Override
    public AuthorizationAccessPolicyContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

