/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.util.Collections;
import java.util.Map;

public final class AuthorizationContractImpl
implements AuthorizationContract,
AuthorizationContract.Definition,
AuthorizationContract.Update {
    private AuthorizationContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String authorizationProviderId;
    private String authorizationId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public AuthorizationType authorizationType() {
        return this.innerModel().authorizationType();
    }

    @Override
    public OAuth2GrantType oAuth2GrantType() {
        return this.innerModel().oAuth2GrantType();
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public AuthorizationError error() {
        return this.innerModel().error();
    }

    @Override
    public String status() {
        return this.innerModel().status();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AuthorizationContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizationContractImpl withExistingAuthorizationProvider(String resourceGroupName, String serviceName, String authorizationProviderId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.authorizationProviderId = authorizationProviderId;
        return this;
    }

    @Override
    public AuthorizationContract create() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    AuthorizationContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationContractInner();
        this.serviceManager = serviceManager;
        this.authorizationId = name;
        this.createIfMatch = null;
    }

    @Override
    public AuthorizationContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public AuthorizationContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    AuthorizationContractImpl(AuthorizationContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationProviders");
        this.authorizationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizations");
    }

    @Override
    public AuthorizationContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, Context.NONE).getValue();
        return this;
    }

    @Override
    public AuthorizationContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizations().getWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, context).getValue();
        return this;
    }

    @Override
    public AuthorizationsConfirmConsentCodeResponse confirmConsentCodeWithResponse(AuthorizationConfirmConsentCodeRequestContract parameters, Context context) {
        return this.serviceManager.authorizations().confirmConsentCodeWithResponse(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, parameters, context);
    }

    @Override
    public void confirmConsentCode(AuthorizationConfirmConsentCodeRequestContract parameters) {
        this.serviceManager.authorizations().confirmConsentCode(this.resourceGroupName, this.serviceName, this.authorizationProviderId, this.authorizationId, parameters);
    }

    @Override
    public AuthorizationContractImpl withAuthorizationType(AuthorizationType authorizationType) {
        this.innerModel().withAuthorizationType(authorizationType);
        return this;
    }

    @Override
    public AuthorizationContractImpl withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.innerModel().withOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    @Override
    public AuthorizationContractImpl withParameters(Map<String, String> parameters) {
        this.innerModel().withParameters(parameters);
        return this;
    }

    @Override
    public AuthorizationContractImpl withError(AuthorizationError error) {
        this.innerModel().withError(error);
        return this;
    }

    @Override
    public AuthorizationContractImpl withStatus(String status) {
        this.innerModel().withStatus(status);
        return this;
    }

    @Override
    public AuthorizationContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

