/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationLoginLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationLoginResponseContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinksPostResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginRequestContract;
import reactor.core.publisher.Mono;

public final class AuthorizationLoginLinksClientImpl
implements AuthorizationLoginLinksClient {
    private final AuthorizationLoginLinksService service;
    private final ApiManagementClientImpl client;

    AuthorizationLoginLinksClientImpl(ApiManagementClientImpl client) {
        this.service = (AuthorizationLoginLinksService)RestProxy.create(AuthorizationLoginLinksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationLoginLinksPostResponse> postWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.post(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationLoginLinksPostResponse> postWithResponseAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.post(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId, authorizationId, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizationLoginResponseContractInner> postAsync(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters) {
        return this.postWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationLoginLinksPostResponse postWithResponse(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters, Context context) {
        return (AuthorizationLoginLinksPostResponse)((Object)this.postWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizationLoginResponseContractInner post(String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters) {
        return this.postWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientA")
    public static interface AuthorizationLoginLinksService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/getLoginLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<AuthorizationLoginLinksPostResponse> post(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="authorizationProviderId") String var4, @PathParam(value="authorizationId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") AuthorizationLoginRequestContract var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

