/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.BackendsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendContractInner;
import com.azure.resourcemanager.apimanagement.implementation.BackendContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.BackendContract;
import com.azure.resourcemanager.apimanagement.models.BackendReconnectContract;
import com.azure.resourcemanager.apimanagement.models.Backends;
import com.azure.resourcemanager.apimanagement.models.BackendsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.BackendsGetResponse;

public final class BackendsImpl
implements Backends {
    private static final ClientLogger LOGGER = new ClientLogger(BackendsImpl.class);
    private final BackendsClient innerClient;
    private final ApiManagementManager serviceManager;

    public BackendsImpl(BackendsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BackendContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<BackendContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackendContractImpl((BackendContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackendContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<BackendContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackendContractImpl((BackendContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public BackendsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String backendId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, backendId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String backendId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, backendId);
    }

    @Override
    public Response<BackendContract> getWithResponse(String resourceGroupName, String serviceName, String backendId, Context context) {
        BackendsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, backendId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackendContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BackendContract get(String resourceGroupName, String serviceName, String backendId) {
        BackendContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, backendId);
        if (inner != null) {
            return new BackendContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String backendId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, backendId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String backendId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, backendId, ifMatch);
    }

    @Override
    public Response<Void> reconnectWithResponse(String resourceGroupName, String serviceName, String backendId, BackendReconnectContract parameters, Context context) {
        return this.serviceClient().reconnectWithResponse(resourceGroupName, serviceName, backendId, parameters, context);
    }

    @Override
    public void reconnect(String resourceGroupName, String serviceName, String backendId) {
        this.serviceClient().reconnect(resourceGroupName, serviceName, backendId);
    }

    @Override
    public BackendContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String backendId = ResourceManagerUtils.getValueFromIdByName(id, "backends");
        if (backendId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backends'.", id)));
        }
        return (BackendContract)this.getWithResponse(resourceGroupName, serviceName, backendId, Context.NONE).getValue();
    }

    @Override
    public Response<BackendContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String backendId = ResourceManagerUtils.getValueFromIdByName(id, "backends");
        if (backendId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backends'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, backendId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String backendId = ResourceManagerUtils.getValueFromIdByName(id, "backends");
        if (backendId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backends'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, backendId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String backendId = ResourceManagerUtils.getValueFromIdByName(id, "backends");
        if (backendId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backends'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, backendId, ifMatch, context);
    }

    private BackendsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackendContractImpl define(String name) {
        return new BackendContractImpl(name, this.manager());
    }
}

