/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.CertificateContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.CertificateContract;
import com.azure.resourcemanager.apimanagement.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import java.time.OffsetDateTime;

public final class CertificateContractImpl
implements CertificateContract,
CertificateContract.Definition,
CertificateContract.Update {
    private CertificateContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String certificateId;
    private String createIfMatch;
    private CertificateCreateOrUpdateParameters createParameters;
    private String updateIfMatch;
    private CertificateCreateOrUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String subject() {
        return this.innerModel().subject();
    }

    @Override
    public String thumbprint() {
        return this.innerModel().thumbprint();
    }

    @Override
    public OffsetDateTime expirationDate() {
        return this.innerModel().expirationDate();
    }

    @Override
    public KeyVaultContractProperties keyVault() {
        return this.innerModel().keyVault();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CertificateContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public CertificateContract create() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, this.createParameters, this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public CertificateContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, this.createParameters, this.createIfMatch, context).getValue();
        return this;
    }

    CertificateContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new CertificateContractInner();
        this.serviceManager = serviceManager;
        this.certificateId = name;
        this.createIfMatch = null;
        this.createParameters = new CertificateCreateOrUpdateParameters();
    }

    @Override
    public CertificateContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new CertificateCreateOrUpdateParameters();
        return this;
    }

    @Override
    public CertificateContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, this.updateParameters, this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public CertificateContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, this.updateParameters, this.updateIfMatch, context).getValue();
        return this;
    }

    CertificateContractImpl(CertificateContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.certificateId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    @Override
    public CertificateContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, Context.NONE).getValue();
        return this;
    }

    @Override
    public CertificateContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, context).getValue();
        return this;
    }

    @Override
    public Response<CertificateContract> refreshSecretWithResponse(Context context) {
        return this.serviceManager.certificates().refreshSecretWithResponse(this.resourceGroupName, this.serviceName, this.certificateId, context);
    }

    @Override
    public CertificateContract refreshSecret() {
        return this.serviceManager.certificates().refreshSecret(this.resourceGroupName, this.serviceName, this.certificateId);
    }

    @Override
    public CertificateContractImpl withData(String data) {
        if (this.isInCreateMode()) {
            this.createParameters.withData(data);
            return this;
        }
        this.updateParameters.withData(data);
        return this;
    }

    @Override
    public CertificateContractImpl withPassword(String password) {
        if (this.isInCreateMode()) {
            this.createParameters.withPassword(password);
            return this;
        }
        this.updateParameters.withPassword(password);
        return this;
    }

    @Override
    public CertificateContractImpl withKeyVault(KeyVaultContractCreateProperties keyVault) {
        if (this.isInCreateMode()) {
            this.createParameters.withKeyVault(keyVault);
            return this;
        }
        this.updateParameters.withKeyVault(keyVault);
        return this;
    }

    @Override
    public CertificateContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

