/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.ContentItemsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentItemContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ContentItemContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ContentItemContract;
import com.azure.resourcemanager.apimanagement.models.ContentItems;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetResponse;

public final class ContentItemsImpl
implements ContentItems {
    private static final ClientLogger LOGGER = new ClientLogger(ContentItemsImpl.class);
    private final ContentItemsClient innerClient;
    private final ApiManagementManager serviceManager;

    public ContentItemsImpl(ContentItemsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ContentItemContract> listByService(String resourceGroupName, String serviceName, String contentTypeId) {
        PagedIterable<ContentItemContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, contentTypeId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentItemContractImpl((ContentItemContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ContentItemContract> listByService(String resourceGroupName, String serviceName, String contentTypeId, Context context) {
        PagedIterable<ContentItemContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, contentTypeId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentItemContractImpl((ContentItemContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public ContentItemsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, contentTypeId, contentItemId);
    }

    @Override
    public Response<ContentItemContract> getWithResponse(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId, Context context) {
        ContentItemsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ContentItemContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ContentItemContract get(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId) {
        ContentItemContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, contentTypeId, contentItemId);
        if (inner != null) {
            return new ContentItemContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch);
    }

    @Override
    public ContentItemContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return (ContentItemContract)this.getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, Context.NONE).getValue();
    }

    @Override
    public Response<ContentItemContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch, context);
    }

    private ContentItemsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContentItemContractImpl define(String name) {
        return new ContentItemContractImpl(name, this.manager());
    }
}

