/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.DocumentationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.DocumentationContract;
import com.azure.resourcemanager.apimanagement.models.DocumentationUpdateContract;

public final class DocumentationContractImpl
implements DocumentationContract,
DocumentationContract.Definition,
DocumentationContract.Update {
    private DocumentationContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String documentationId;
    private String createIfMatch;
    private String updateIfMatch;
    private DocumentationUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String title() {
        return this.innerModel().title();
    }

    @Override
    public String content() {
        return this.innerModel().content();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DocumentationContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public DocumentationContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public DocumentationContract create() {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public DocumentationContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    DocumentationContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new DocumentationContractInner();
        this.serviceManager = serviceManager;
        this.documentationId = name;
        this.createIfMatch = null;
    }

    @Override
    public DocumentationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DocumentationUpdateContract();
        return this;
    }

    @Override
    public DocumentationContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().updateWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public DocumentationContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().updateWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    DocumentationContractImpl(DocumentationContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.documentationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "documentations");
    }

    @Override
    public DocumentationContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().getWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, Context.NONE).getValue();
        return this;
    }

    @Override
    public DocumentationContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDocumentations().getWithResponse(this.resourceGroupName, this.serviceName, this.documentationId, context).getValue();
        return this;
    }

    @Override
    public DocumentationContractImpl withTitle(String title) {
        if (this.isInCreateMode()) {
            this.innerModel().withTitle(title);
            return this;
        }
        this.updateParameters.withTitle(title);
        return this;
    }

    @Override
    public DocumentationContractImpl withContent(String content) {
        if (this.isInCreateMode()) {
            this.innerModel().withContent(content);
            return this;
        }
        this.updateParameters.withContent(content);
        return this;
    }

    @Override
    public DocumentationContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

