/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.DocumentationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DocumentationContractInner;
import com.azure.resourcemanager.apimanagement.implementation.DocumentationContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.DocumentationContract;
import com.azure.resourcemanager.apimanagement.models.Documentations;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetResponse;

public final class DocumentationsImpl
implements Documentations {
    private static final ClientLogger LOGGER = new ClientLogger(DocumentationsImpl.class);
    private final DocumentationsClient innerClient;
    private final ApiManagementManager serviceManager;

    public DocumentationsImpl(DocumentationsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DocumentationContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<DocumentationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DocumentationContractImpl((DocumentationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DocumentationContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<DocumentationContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DocumentationContractImpl((DocumentationContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public DocumentationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String documentationId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, documentationId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String documentationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, documentationId);
    }

    @Override
    public Response<DocumentationContract> getWithResponse(String resourceGroupName, String serviceName, String documentationId, Context context) {
        DocumentationsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, documentationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DocumentationContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DocumentationContract get(String resourceGroupName, String serviceName, String documentationId) {
        DocumentationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, documentationId);
        if (inner != null) {
            return new DocumentationContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String documentationId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, documentationId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String documentationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, documentationId, ifMatch);
    }

    @Override
    public DocumentationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return (DocumentationContract)this.getWithResponse(resourceGroupName, serviceName, documentationId, Context.NONE).getValue();
    }

    @Override
    public Response<DocumentationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, documentationId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, documentationId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, documentationId, ifMatch, context);
    }

    private DocumentationsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public DocumentationContractImpl define(String name) {
        return new DocumentationContractImpl(name, this.manager());
    }
}

