/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.EmailTemplateContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateContract;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateParametersContractProperties;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.TemplateName;
import java.util.Collections;
import java.util.List;

public final class EmailTemplateContractImpl
implements EmailTemplateContract,
EmailTemplateContract.Definition,
EmailTemplateContract.Update {
    private EmailTemplateContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private TemplateName templateName;
    private String createIfMatch;
    private EmailTemplateUpdateParameters createParameters;
    private String updateIfMatch;
    private EmailTemplateUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String subject() {
        return this.innerModel().subject();
    }

    @Override
    public String body() {
        return this.innerModel().body();
    }

    @Override
    public String title() {
        return this.innerModel().title();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Boolean isDefault() {
        return this.innerModel().isDefault();
    }

    @Override
    public List<EmailTemplateParametersContractProperties> parameters() {
        List<EmailTemplateParametersContractProperties> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public EmailTemplateContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public EmailTemplateContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public EmailTemplateContract create() {
        this.innerObject = (EmailTemplateContractInner)((Object)this.serviceManager.serviceClient().getEmailTemplates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.templateName, this.createParameters, this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public EmailTemplateContract create(Context context) {
        this.innerObject = (EmailTemplateContractInner)((Object)this.serviceManager.serviceClient().getEmailTemplates().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.templateName, this.createParameters, this.createIfMatch, context).getValue());
        return this;
    }

    EmailTemplateContractImpl(TemplateName name, ApiManagementManager serviceManager) {
        this.innerObject = new EmailTemplateContractInner();
        this.serviceManager = serviceManager;
        this.templateName = name;
        this.createIfMatch = null;
        this.createParameters = new EmailTemplateUpdateParameters();
    }

    @Override
    public EmailTemplateContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new EmailTemplateUpdateParameters();
        return this;
    }

    @Override
    public EmailTemplateContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getEmailTemplates().updateWithResponse(this.resourceGroupName, this.serviceName, this.templateName, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public EmailTemplateContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEmailTemplates().updateWithResponse(this.resourceGroupName, this.serviceName, this.templateName, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    EmailTemplateContractImpl(EmailTemplateContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.templateName = TemplateName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "templates"));
    }

    @Override
    public EmailTemplateContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getEmailTemplates().getWithResponse(this.resourceGroupName, this.serviceName, this.templateName, Context.NONE).getValue();
        return this;
    }

    @Override
    public EmailTemplateContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEmailTemplates().getWithResponse(this.resourceGroupName, this.serviceName, this.templateName, context).getValue();
        return this;
    }

    @Override
    public EmailTemplateContractImpl withSubject(String subject) {
        if (this.isInCreateMode()) {
            this.createParameters.withSubject(subject);
            return this;
        }
        this.updateParameters.withSubject(subject);
        return this;
    }

    @Override
    public EmailTemplateContractImpl withTitle(String title) {
        if (this.isInCreateMode()) {
            this.createParameters.withTitle(title);
            return this;
        }
        this.updateParameters.withTitle(title);
        return this;
    }

    @Override
    public EmailTemplateContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public EmailTemplateContractImpl withBody(String body) {
        if (this.isInCreateMode()) {
            this.createParameters.withBody(body);
            return this;
        }
        this.updateParameters.withBody(body);
        return this;
    }

    @Override
    public EmailTemplateContractImpl withParameters(List<EmailTemplateParametersContractProperties> parameters) {
        if (this.isInCreateMode()) {
            this.createParameters.withParameters(parameters);
            return this;
        }
        this.updateParameters.withParameters(parameters);
        return this;
    }

    @Override
    public EmailTemplateContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

