/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apimanagement.fluent.GraphQLApiResolverPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ApiManagementClientImpl;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GraphQLApiResolverPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;
import reactor.core.publisher.Mono;

public final class GraphQLApiResolverPoliciesClientImpl
implements GraphQLApiResolverPoliciesClient {
    private final GraphQLApiResolverPoliciesService service;
    private final ApiManagementClientImpl client;

    GraphQLApiResolverPoliciesClientImpl(ApiManagementClientImpl client) {
        this.service = (GraphQLApiResolverPoliciesService)RestProxy.create(GraphQLApiResolverPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyContractInner>> listByResolverSinglePageAsync(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResolver(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyCollectionInner)res.getValue()).value(), ((PolicyCollectionInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyContractInner>> listByResolverSinglePageAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResolver(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyCollectionInner)res.getValue()).value(), ((PolicyCollectionInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyContractInner> listByResolverAsync(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        return new PagedFlux(() -> this.listByResolverSinglePageAsync(resourceGroupName, serviceName, apiId, resolverId), nextLink -> this.listByResolverNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyContractInner> listByResolverAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        return new PagedFlux(() -> this.listByResolverSinglePageAsync(resourceGroupName, serviceName, apiId, resolverId, context), nextLink -> this.listByResolverNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyContractInner> listByResolver(String resourceGroupName, String serviceName, String apiId, String resolverId) {
        return new PagedIterable(this.listByResolverAsync(resourceGroupName, serviceName, apiId, resolverId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyContractInner> listByResolver(String resourceGroupName, String serviceName, String apiId, String resolverId, Context context) {
        return new PagedIterable(this.listByResolverAsync(resourceGroupName, serviceName, apiId, resolverId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesGetEntityTagResponse> getEntityTagWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEntityTag(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getEntityTagAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        return this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GraphQLApiResolverPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, Context context) {
        return (GraphQLApiResolverPoliciesGetEntityTagResponse)((Object)this.getEntityTagWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        this.getEntityTagWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyExportFormat format) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, format, policyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, format, policyId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PolicyContractInner> getAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        PolicyExportFormat format = null;
        return this.getWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, format).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GraphQLApiResolverPoliciesGetResponse getWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        return (GraphQLApiResolverPoliciesGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, format, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyContractInner get(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId) {
        PolicyExportFormat format = null;
        return this.getWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, format, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GraphQLApiResolverPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PolicyContractInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GraphQLApiResolverPoliciesCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        return (GraphQLApiResolverPoliciesCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyContractInner createOrUpdate(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, PolicyContractInner parameters) {
        String ifMatch = null;
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, parameters, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apiId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiId is required and cannot be null."));
        }
        if (resolverId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resolverId is required and cannot be null."));
        }
        if (policyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apiId, String resolverId, PolicyIdName policyId, String ifMatch) {
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, resolverId, policyId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyContractInner>> listByResolverNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResolverNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyCollectionInner)res.getValue()).value(), ((PolicyCollectionInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyContractInner>> listByResolverNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResolverNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyCollectionInner)res.getValue()).value(), ((PolicyCollectionInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApiManagementClientG")
    public static interface GraphQLApiResolverPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyCollectionInner>> listByResolver(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="resolverId") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<GraphQLApiResolverPoliciesGetEntityTagResponse> getEntityTag(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="resolverId") String var5, @PathParam(value="policyId") PolicyIdName var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<GraphQLApiResolverPoliciesGetResponse> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="resolverId") String var5, @QueryParam(value="format") PolicyExportFormat var6, @PathParam(value="policyId") PolicyIdName var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<GraphQLApiResolverPoliciesCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="resolverId") String var5, @PathParam(value="policyId") PolicyIdName var6, @HeaderParam(value="If-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @BodyParam(value="application/json") PolicyContractInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serviceName") String var3, @PathParam(value="apiId") String var4, @PathParam(value="resolverId") String var5, @PathParam(value="policyId") PolicyIdName var6, @HeaderParam(value="If-Match") String var7, @QueryParam(value="api-version") String var8, @PathParam(value="subscriptionId") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyCollectionInner>> listByResolverNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

