/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.GroupsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractInner;
import com.azure.resourcemanager.apimanagement.implementation.GroupContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.GroupContract;
import com.azure.resourcemanager.apimanagement.models.Groups;
import com.azure.resourcemanager.apimanagement.models.GroupsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GroupsGetResponse;

public final class GroupsImpl
implements Groups {
    private static final ClientLogger LOGGER = new ClientLogger(GroupsImpl.class);
    private final GroupsClient innerClient;
    private final ApiManagementManager serviceManager;

    public GroupsImpl(GroupsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GroupContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl((GroupContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public GroupsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String groupId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, groupId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String groupId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, groupId);
    }

    @Override
    public Response<GroupContract> getWithResponse(String resourceGroupName, String serviceName, String groupId, Context context) {
        GroupsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, groupId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GroupContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GroupContract get(String resourceGroupName, String serviceName, String groupId) {
        GroupContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, groupId);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String groupId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, groupId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String groupId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, groupId, ifMatch);
    }

    @Override
    public GroupContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String groupId = ResourceManagerUtils.getValueFromIdByName(id, "groups");
        if (groupId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groups'.", id)));
        }
        return (GroupContract)this.getWithResponse(resourceGroupName, serviceName, groupId, Context.NONE).getValue();
    }

    @Override
    public Response<GroupContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String groupId = ResourceManagerUtils.getValueFromIdByName(id, "groups");
        if (groupId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, groupId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String groupId = ResourceManagerUtils.getValueFromIdByName(id, "groups");
        if (groupId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groups'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, groupId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String groupId = ResourceManagerUtils.getValueFromIdByName(id, "groups");
        if (groupId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'groups'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, groupId, ifMatch, context);
    }

    private GroupsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public GroupContractImpl define(String name) {
        return new GroupContractImpl(name, this.manager());
    }
}

