/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueCommentContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.IssueCommentContract;
import java.time.OffsetDateTime;

public final class IssueCommentContractImpl
implements IssueCommentContract,
IssueCommentContract.Definition,
IssueCommentContract.Update {
    private IssueCommentContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String issueId;
    private String commentId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String text() {
        return this.innerModel().text();
    }

    @Override
    public OffsetDateTime createdDate() {
        return this.innerModel().createdDate();
    }

    @Override
    public String userId() {
        return this.innerModel().userId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IssueCommentContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public IssueCommentContractImpl withExistingIssue(String resourceGroupName, String serviceName, String apiId, String issueId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        this.issueId = issueId;
        return this;
    }

    @Override
    public IssueCommentContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueCommentContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    IssueCommentContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new IssueCommentContractInner();
        this.serviceManager = serviceManager;
        this.commentId = name;
        this.createIfMatch = null;
    }

    @Override
    public IssueCommentContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public IssueCommentContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueCommentContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    IssueCommentContractImpl(IssueCommentContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.issueId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "issues");
        this.commentId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "comments");
    }

    @Override
    public IssueCommentContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, Context.NONE).getValue();
        return this;
    }

    @Override
    public IssueCommentContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiIssueComments().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.issueId, this.commentId, context).getValue();
        return this;
    }

    @Override
    public IssueCommentContractImpl withText(String text) {
        this.innerModel().withText(text);
        return this;
    }

    @Override
    public IssueCommentContractImpl withCreatedDate(OffsetDateTime createdDate) {
        this.innerModel().withCreatedDate(createdDate);
        return this;
    }

    @Override
    public IssueCommentContractImpl withUserId(String userId) {
        this.innerModel().withUserId(userId);
        return this;
    }

    @Override
    public IssueCommentContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

