/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.LoggersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.LoggerContractInner;
import com.azure.resourcemanager.apimanagement.implementation.LoggerContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.LoggerContract;
import com.azure.resourcemanager.apimanagement.models.Loggers;
import com.azure.resourcemanager.apimanagement.models.LoggersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.LoggersGetResponse;

public final class LoggersImpl
implements Loggers {
    private static final ClientLogger LOGGER = new ClientLogger(LoggersImpl.class);
    private final LoggersClient innerClient;
    private final ApiManagementManager serviceManager;

    public LoggersImpl(LoggersClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LoggerContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<LoggerContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LoggerContractImpl((LoggerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LoggerContract> listByService(String resourceGroupName, String serviceName, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<LoggerContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LoggerContractImpl((LoggerContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public LoggersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, String loggerId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, loggerId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, String loggerId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, loggerId);
    }

    @Override
    public Response<LoggerContract> getWithResponse(String resourceGroupName, String serviceName, String loggerId, Context context) {
        LoggersGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, loggerId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LoggerContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LoggerContract get(String resourceGroupName, String serviceName, String loggerId) {
        LoggerContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, loggerId);
        if (inner != null) {
            return new LoggerContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String loggerId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, loggerId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String loggerId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, loggerId, ifMatch);
    }

    @Override
    public LoggerContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String loggerId = ResourceManagerUtils.getValueFromIdByName(id, "loggers");
        if (loggerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'loggers'.", id)));
        }
        return (LoggerContract)this.getWithResponse(resourceGroupName, serviceName, loggerId, Context.NONE).getValue();
    }

    @Override
    public Response<LoggerContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String loggerId = ResourceManagerUtils.getValueFromIdByName(id, "loggers");
        if (loggerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'loggers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, loggerId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String loggerId = ResourceManagerUtils.getValueFromIdByName(id, "loggers");
        if (loggerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'loggers'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, loggerId, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String loggerId = ResourceManagerUtils.getValueFromIdByName(id, "loggers");
        if (loggerId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'loggers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, loggerId, ifMatch, context);
    }

    private LoggersClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public LoggerContractImpl define(String name) {
        return new LoggerContractImpl(name, this.manager());
    }
}

