/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.OpenidConnectProviderContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.ClientSecretContract;
import com.azure.resourcemanager.apimanagement.models.OpenidConnectProviderContract;
import com.azure.resourcemanager.apimanagement.models.OpenidConnectProviderUpdateContract;

public final class OpenidConnectProviderContractImpl
implements OpenidConnectProviderContract,
OpenidConnectProviderContract.Definition,
OpenidConnectProviderContract.Update {
    private OpenidConnectProviderContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String opid;
    private String createIfMatch;
    private String updateIfMatch;
    private OpenidConnectProviderUpdateContract updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String metadataEndpoint() {
        return this.innerModel().metadataEndpoint();
    }

    @Override
    public String clientId() {
        return this.innerModel().clientId();
    }

    @Override
    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    @Override
    public Boolean useInTestConsole() {
        return this.innerModel().useInTestConsole();
    }

    @Override
    public Boolean useInApiDocumentation() {
        return this.innerModel().useInApiDocumentation();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public OpenidConnectProviderContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public OpenidConnectProviderContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public OpenidConnectProviderContract create() {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.opid, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public OpenidConnectProviderContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.opid, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    OpenidConnectProviderContractImpl(String name, ApiManagementManager serviceManager) {
        this.innerObject = new OpenidConnectProviderContractInner();
        this.serviceManager = serviceManager;
        this.opid = name;
        this.createIfMatch = null;
    }

    @Override
    public OpenidConnectProviderContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new OpenidConnectProviderUpdateContract();
        return this;
    }

    @Override
    public OpenidConnectProviderContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().updateWithResponse(this.resourceGroupName, this.serviceName, this.opid, this.updateIfMatch, this.updateParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public OpenidConnectProviderContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().updateWithResponse(this.resourceGroupName, this.serviceName, this.opid, this.updateIfMatch, this.updateParameters, context).getValue();
        return this;
    }

    OpenidConnectProviderContractImpl(OpenidConnectProviderContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.opid = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "openidConnectProviders");
    }

    @Override
    public OpenidConnectProviderContract refresh() {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.opid, Context.NONE).getValue();
        return this;
    }

    @Override
    public OpenidConnectProviderContract refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getOpenIdConnectProviders().getWithResponse(this.resourceGroupName, this.serviceName, this.opid, context).getValue();
        return this;
    }

    @Override
    public Response<ClientSecretContract> listSecretsWithResponse(Context context) {
        return this.serviceManager.openIdConnectProviders().listSecretsWithResponse(this.resourceGroupName, this.serviceName, this.opid, context);
    }

    @Override
    public ClientSecretContract listSecrets() {
        return this.serviceManager.openIdConnectProviders().listSecrets(this.resourceGroupName, this.serviceName, this.opid);
    }

    @Override
    public OpenidConnectProviderContractImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withMetadataEndpoint(String metadataEndpoint) {
        if (this.isInCreateMode()) {
            this.innerModel().withMetadataEndpoint(metadataEndpoint);
            return this;
        }
        this.updateParameters.withMetadataEndpoint(metadataEndpoint);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withClientId(String clientId) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientId(clientId);
            return this;
        }
        this.updateParameters.withClientId(clientId);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withClientSecret(String clientSecret) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientSecret(clientSecret);
            return this;
        }
        this.updateParameters.withClientSecret(clientSecret);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withUseInTestConsole(Boolean useInTestConsole) {
        if (this.isInCreateMode()) {
            this.innerModel().withUseInTestConsole(useInTestConsole);
            return this;
        }
        this.updateParameters.withUseInTestConsole(useInTestConsole);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withUseInApiDocumentation(Boolean useInApiDocumentation) {
        if (this.isInCreateMode()) {
            this.innerModel().withUseInApiDocumentation(useInApiDocumentation);
            return this;
        }
        this.updateParameters.withUseInApiDocumentation(useInApiDocumentation);
        return this;
    }

    @Override
    public OpenidConnectProviderContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

