/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyContractImpl;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.Policies;
import com.azure.resourcemanager.apimanagement.models.PoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.PoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.PoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class PoliciesImpl
implements Policies {
    private static final ClientLogger LOGGER = new ClientLogger(PoliciesImpl.class);
    private final PoliciesClient innerClient;
    private final ApiManagementManager serviceManager;

    public PoliciesImpl(PoliciesClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PolicyContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PolicyContract> listByService(String resourceGroupName, String serviceName, Context context) {
        PagedIterable<PolicyContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PolicyContractImpl((PolicyContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, policyId, context);
    }

    @Override
    public void getEntityTag(String resourceGroupName, String serviceName, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, policyId);
    }

    @Override
    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        PoliciesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract get(String resourceGroupName, String serviceName, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        PoliciesCreateOrUpdateResponse inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, serviceName, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyContractImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, policyId, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, policyId, ifMatch);
    }

    private PoliciesClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

