/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apimanagement.models.PolicyContentFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class PolicyContractImpl
implements PolicyContract,
PolicyContract.Definition,
PolicyContract.Update {
    private PolicyContractInner innerObject;
    private final ApiManagementManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String apiId;
    private String operationId;
    private PolicyIdName policyId;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public PolicyContentFormat format() {
        return this.innerModel().format();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PolicyContractInner innerModel() {
        return this.innerObject;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }

    @Override
    public PolicyContractImpl withExistingOperation(String resourceGroupName, String serviceName, String apiId, String operationId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        this.operationId = operationId;
        return this;
    }

    @Override
    public PolicyContract create() {
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, this.innerModel(), this.createIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyContract create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, this.innerModel(), this.createIfMatch, context).getValue();
        return this;
    }

    PolicyContractImpl(PolicyIdName name, ApiManagementManager serviceManager) {
        this.innerObject = new PolicyContractInner();
        this.serviceManager = serviceManager;
        this.policyId = name;
        this.createIfMatch = null;
    }

    @Override
    public PolicyContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public PolicyContract apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, this.innerModel(), this.updateIfMatch, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyContract apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, this.innerModel(), this.updateIfMatch, context).getValue();
        return this;
    }

    PolicyContractImpl(PolicyContractInner innerObject, ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.operationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "operations");
        this.policyId = PolicyIdName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "policies"));
    }

    @Override
    public PolicyContract refresh() {
        PolicyExportFormat localFormat = null;
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, localFormat, Context.NONE).getValue();
        return this;
    }

    @Override
    public PolicyContract refresh(Context context) {
        PolicyExportFormat localFormat = null;
        this.innerObject = this.serviceManager.serviceClient().getApiOperationPolicies().getWithResponse(this.resourceGroupName, this.serviceName, this.apiId, this.operationId, this.policyId, localFormat, context).getValue();
        return this;
    }

    @Override
    public PolicyContractImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public PolicyContractImpl withFormat(PolicyContentFormat format) {
        this.innerModel().withFormat(format);
        return this;
    }

    @Override
    public PolicyContractImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

