/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.ApiManagementManager;
import com.azure.resourcemanager.apimanagement.fluent.PolicyDescriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyDescriptionCollectionInner;
import com.azure.resourcemanager.apimanagement.implementation.PolicyDescriptionCollectionImpl;
import com.azure.resourcemanager.apimanagement.models.PolicyDescriptionCollection;
import com.azure.resourcemanager.apimanagement.models.PolicyDescriptions;
import com.azure.resourcemanager.apimanagement.models.PolicyScopeContract;

public final class PolicyDescriptionsImpl
implements PolicyDescriptions {
    private static final ClientLogger LOGGER = new ClientLogger(PolicyDescriptionsImpl.class);
    private final PolicyDescriptionsClient innerClient;
    private final ApiManagementManager serviceManager;

    public PolicyDescriptionsImpl(PolicyDescriptionsClient innerClient, ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PolicyDescriptionCollection> listByServiceWithResponse(String resourceGroupName, String serviceName, PolicyScopeContract scope, Context context) {
        Response<PolicyDescriptionCollectionInner> inner = this.serviceClient().listByServiceWithResponse(resourceGroupName, serviceName, scope, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PolicyDescriptionCollectionImpl((PolicyDescriptionCollectionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PolicyDescriptionCollection listByService(String resourceGroupName, String serviceName) {
        PolicyDescriptionCollectionInner inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        if (inner != null) {
            return new PolicyDescriptionCollectionImpl(inner, this.manager());
        }
        return null;
    }

    private PolicyDescriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiManagementManager manager() {
        return this.serviceManager;
    }
}

